/**
 * This file is generated by dconfig2cpp.
 * Command line arguments: ./build/tools/dconfig2cpp/dconfig2cpp ./tests/data/dconf-global.meta.json -o ./toolGenerate/dconfig2cpp/dconf-global_meta.hpp
 * Generation time: 2026-01-21T14:02:35
 * JSON file version: 1.0
 *
 * WARNING: DO NOT MODIFY THIS FILE MANUALLY.
 * If you need to change the content, please modify the dconfig2cpp tool.
 */

#ifndef DCONFIG_DCONF-GLOBAL_META_H
#define DCONFIG_DCONF-GLOBAL_META_H

#include <QThread>
#include <QVariant>
#include <QPointer>
#include <QDebug>
#include <QAtomicPointer>
#include <QAtomicInteger>
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#include <QProperty>
#endif
#include <QEvent>
#include <DSGApplication>
#include <DConfig>

class dconfig_dconf-global_meta : public QObject {
    Q_OBJECT

    Q_PROPERTY(QString key3 READ key3 WRITE setKey3 NOTIFY key3Changed RESET resetKey3)
    Q_CLASSINFO("DConfigKeyList", "key3")
    Q_CLASSINFO("DConfigFileName", "dconf-global.meta")
    Q_CLASSINFO("DConfigFileVersion", "1.0")

public:
    explicit dconfig_dconf-global_meta(QThread *thread, DTK_CORE_NAMESPACE::DConfigBackend *backend,
                        const QString &name, const QString &appId, const QString &subpath,
                        bool isGeneric, QObject *parent)
                  : QObject(parent), m_data(new Data) {
        m_data->m_userConfig = this;
        m_data->moveToThread(this->thread());

        if (!thread->isRunning()) {
            qWarning() << QLatin1String("Warning: The provided thread is not running.");
        }
        Q_ASSERT(QThread::currentThread() != thread);
        auto worker = new QObject();
        worker->moveToThread(thread);

        QPointer<Data> safeData(m_data);

        QMetaObject::invokeMethod(worker, [safeData, backend, name, appId, subpath, isGeneric, worker]() mutable {
            delete worker;
            worker = nullptr;

            if (!safeData->m_status.testAndSetOrdered(static_cast<int>(Data::Status::Invalid),
                                                      static_cast<int>(Data::Status::Initializing))) {
                // CAS failed: status changed (e.g., set to Destroyed by destructor)
                // Schedule deletion of Data object via deleteLater to avoid direct delete in Config thread
                safeData->deleteLater();
                return;
            }

            DTK_CORE_NAMESPACE::DConfig *config = nullptr;
            if (isGeneric) {
                if (backend) {
                    config = DTK_CORE_NAMESPACE::DConfig::createGeneric(backend, name, subpath, nullptr);
                } else {
                    config = DTK_CORE_NAMESPACE::DConfig::createGeneric(name, subpath, nullptr);
                }
            } else {
                if (backend) {
                    if (appId.isNull()) {
                        config = DTK_CORE_NAMESPACE::DConfig::create(backend, DTK_CORE_NAMESPACE::DSGApplication::id(),
                                                                     name, subpath, nullptr);
                    } else {
                        config = DTK_CORE_NAMESPACE::DConfig::create(backend, appId, name, subpath, nullptr);
                    }
                } else {
                    if (appId.isNull()) {
                        config = DTK_CORE_NAMESPACE::DConfig::create(DTK_CORE_NAMESPACE::DSGApplication::id(),
                                                                     name, subpath, nullptr);
                    } else {
                        config = DTK_CORE_NAMESPACE::DConfig::create(appId, name, subpath, nullptr);
                    }
                }
            }

            if (!config || !config->isValid()) {
                qWarning() << QLatin1String("Failed to create DConfig instance.");

                QMetaObject::invokeMethod(safeData, [safeData]() {
                    if (safeData->m_status.testAndSetOrdered(static_cast<int>(Data::Status::Initializing),
                                                             static_cast<int>(Data::Status::Failed))) {
                        Q_EMIT safeData->m_userConfig->configInitializeFailed();
                    } else {
                        // CAS failed, destroy data object
                        delete safeData;
                    }
                }, Qt::QueuedConnection);

                if (config)
                    delete config;

                return;
            }
            config->moveToThread(QThread::currentThread());
            // Initialize through Data class
            safeData->initializeInConfigThread(config);

            QMetaObject::invokeMethod(safeData, [safeData, config]() {
                // Try to transition from Initializing to Succeeded
                if (safeData->m_status.testAndSetOrdered(static_cast<int>(Data::Status::Initializing),
                                                         static_cast<int>(Data::Status::Succeeded))) {
                    // CAS succeeded: connect config destroyed signal to cleanup Data, then emit success signal to main thread
                    QObject::connect(config, &QObject::destroyed, safeData, &QObject::deleteLater);
                    if (safeData->m_userConfig) {
                        Q_EMIT safeData->m_userConfig->configInitializeSucceed(config);
                    }
                } else {
                    // CAS failed - state changed (e.g., set to Destroyed)
                    // We must clean up the config we just created
                    config->deleteLater();
                    safeData->deleteLater();
                }
            }, Qt::QueuedConnection);

        });
    }
    static dconfig_dconf-global_meta* create(const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new dconfig_dconf-global_meta(thread, nullptr, QStringLiteral(u"\u0064\u0063\u006f\u006e\u0066\u002d\u0067\u006c\u006f\u0062\u0061\u006c\u002e\u006d\u0065\u0074\u0061"), appId, subpath, false, parent); }
    static dconfig_dconf-global_meta* create(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new dconfig_dconf-global_meta(thread, backend, QStringLiteral(u"\u0064\u0063\u006f\u006e\u0066\u002d\u0067\u006c\u006f\u0062\u0061\u006c\u002e\u006d\u0065\u0074\u0061"), appId, subpath, false, parent); }
    static dconfig_dconf-global_meta* createByName(const QString &name, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new dconfig_dconf-global_meta(thread, nullptr, name, appId, subpath, false, parent); }
    static dconfig_dconf-global_meta* createByName(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &name, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new dconfig_dconf-global_meta(thread, backend, name, appId, subpath, false, parent); }
    static dconfig_dconf-global_meta* createGeneric(const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new dconfig_dconf-global_meta(thread, nullptr, QStringLiteral(u"\u0064\u0063\u006f\u006e\u0066\u002d\u0067\u006c\u006f\u0062\u0061\u006c\u002e\u006d\u0065\u0074\u0061"), {}, subpath, true, parent); }
    static dconfig_dconf-global_meta* create(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new dconfig_dconf-global_meta(thread, backend, QStringLiteral(u"\u0064\u0063\u006f\u006e\u0066\u002d\u0067\u006c\u006f\u0062\u0061\u006c\u002e\u006d\u0065\u0074\u0061"), {}, subpath, true, parent); }
    static dconfig_dconf-global_meta* createGenericByName(const QString &name, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new dconfig_dconf-global_meta(thread, nullptr, name, {}, subpath, true, parent); }
    static dconfig_dconf-global_meta* createGenericByName(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &name, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new dconfig_dconf-global_meta(thread, backend, name, {}, subpath, true, parent); }
    ~dconfig_dconf-global_meta() {
        m_data->m_userConfig = nullptr;
        int oldStatus = m_data->m_status.fetchAndStoreOrdered(static_cast<int>(Data::Status::Destroyed));
        if (oldStatus == static_cast<int>(Data::Status::Succeeded)) {
            // When Succeeded, release config object only
            auto config = m_data->m_config.loadRelaxed();
            Q_ASSERT(config);
            config->deleteLater();
            // m_data will be deleted by config's destroyed signal
        } else if (oldStatus == static_cast<int>(Data::Status::Failed)) {
            // When Failed state, schedule cleanup of Data object
            m_data->deleteLater();
        }
    }

    Q_INVOKABLE DTK_CORE_NAMESPACE::DConfig *config() const {
        return m_data->m_config.loadRelaxed();
    }
    // Deprecated: Use isInitializeSucceeded() instead
    Q_INVOKABLE Q_DECL_DEPRECATED_X("Use isInitializeSucceeded() instead")
    bool isInitializeSucceed() const {
        return isInitializeSucceeded();
    }
    Q_INVOKABLE bool isInitializeSucceeded() const {
        return m_data->m_status.loadRelaxed() == static_cast<int>(Data::Status::Succeeded);
    }
    Q_INVOKABLE bool isInitializeFailed() const {
        return m_data->m_status.loadRelaxed() == static_cast<int>(Data::Status::Failed);
    }
    Q_INVOKABLE bool isInitializing() const {
        return m_data->m_status.loadRelaxed() == static_cast<int>(Data::Status::Initializing);
    }

    Q_INVOKABLE QStringList keyList() const {
        return { QStringLiteral("key3")};
    }

    Q_INVOKABLE bool isDefaultValue(const QString &key) const {
        if (key == QStringLiteral("key3"))
            return key3IsDefaultValue();
        return false;
    }

    QString key3() const {
        return m_data->p_key3;
    }
    void setKey3(const QString &value) {
        auto oldValue = m_data->p_key3;
        m_data->p_key3 = value;
        m_data->markPropertySet(0);
        if (auto config = m_data->m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [config, value]() {
                config->setValue(QStringLiteral("key3"), value);
            });
        }
        if (m_data->p_key3 != oldValue) {
            Q_EMIT key3Changed();
            Q_EMIT valueChanged(QStringLiteral("key3"), value);
        }
    }
    void resetKey3() {
        if (auto config = m_data->m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [config]() {
                config->reset(QStringLiteral("key3"));
            });
        }
    }
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    QBindable<QString> bindableKey3() {
        return QBindable<QString>(this, "key3");
    }
#endif
    Q_INVOKABLE bool key3IsDefaultValue() const {
        return !m_data->testPropertySet(0);
    }
protected:
    bool event(QEvent *e) override {
        if (e->type() == QEvent::ThreadChange) {
            Q_ASSERT(this->thread() == m_data->thread());
        }
        return QObject::event(e);
    }
Q_SIGNALS:
    void configInitializeFailed();
    void configInitializeSucceed(DTK_CORE_NAMESPACE::DConfig *config);
    void valueChanged(const QString &key, const QVariant &value);
    void key3Changed();

private:
    // Prevent external moveToThread calls
    using QObject::moveToThread;
    class Data : public QObject {
    public:
        enum class Status {
            Invalid = 0,
            Initializing = 1,
            Succeeded = 2,
            Failed = 3,
            Destroyed = 4
        };

        explicit Data()
            : QObject(nullptr) {}

        inline void initializeInConfigThread(DTK_CORE_NAMESPACE::DConfig *config) {
            Q_ASSERT(!m_config.loadRelaxed());
            m_config.storeRelaxed(config);
            if (testPropertySet(0)) {
                config->setValue(QStringLiteral("key3"), QVariant::fromValue(p_key3));
            } else {
                updateValue(QStringLiteral("key3"), QVariant::fromValue(p_key3));
            }
            connect(config, &DTK_CORE_NAMESPACE::DConfig::valueChanged, this, [this](const QString &key) {
                updateValue(key);
            }, Qt::DirectConnection);
        }

        inline void updateValue(const QString &key, const QVariant &fallback = QVariant()) {
            if (!m_config.loadRelaxed())
                return;
            Q_ASSERT(QThread::currentThread() == m_config.loadRelaxed()->thread());
            const QVariant &value = m_config.loadRelaxed()->value(key, fallback);
            if (key == QStringLiteral("key3")) {
                markPropertySet(0, !m_config.loadRelaxed()->isDefaultValue(key));
                auto newValue = qvariant_cast<QString>(value);
                QMetaObject::invokeMethod(this, [this, newValue, key, value]() {
                    if (m_userConfig && p_key3 != newValue) {
                        Q_ASSERT(QThread::currentThread() == m_userConfig->thread());
                        p_key3 = newValue;
                        Q_EMIT m_userConfig->key3Changed();
                        Q_EMIT m_userConfig->valueChanged(key, value);
                    }
                });
                return;
            }
        }
        inline void markPropertySet(const int index, bool on = true) {
            if (index < 32) {
                if (on)
                    m_propertySetStatus0.fetchAndOrOrdered(1 << (index - 0));
                else
                    m_propertySetStatus0.fetchAndAndOrdered(~(1 << (index - 0)));
                return;
            }
            Q_UNREACHABLE();
        }
        inline bool testPropertySet(const int index) const {
            if (index < 32) {
                return (m_propertySetStatus0.loadRelaxed() & (1 << (index - 0)));
            }
            Q_UNREACHABLE();
        }
        // Member variables
        QAtomicPointer<DTK_CORE_NAMESPACE::DConfig> m_config = nullptr;
        QAtomicInteger<int> m_status = static_cast<int>(Status::Invalid);
        QPointer<dconfig_dconf-global_meta> m_userConfig = nullptr;
        QAtomicInteger<quint32> m_propertySetStatus0 = 0;

        // Property storage
        // Default value: "global"
        QString p_key3 { QStringLiteral(u"\u0067\u006c\u006f\u0062\u0061\u006c") };
    };

    QPointer<Data> m_data;
};

#endif // DCONFIG_DCONF-GLOBAL_META_H
