/*
 * SPDX-FileCopyrightText: 2023 UnionTech Software Technology Co., Ltd.:
 *
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */
#pragma once

#include "linglong/package/architecture.h"

#include <QString>

#include <optional>

namespace linglong::package {

// This class is a fuzz reference to a tier, use to search a tier.
class FuzzyReference final
{
public:
    static utils::error::Result<FuzzyReference> parse(const std::string &raw) noexcept;
    static utils::error::Result<FuzzyReference>
    create(const std::optional<std::string> &channel,
           const std::string &id,
           const std::optional<std::string> &version,
           const std::optional<Architecture> &arch) noexcept;

    std::optional<std::string> channel;
    std::string id;
    std::optional<std::string> version;
    std::optional<Architecture> arch;

    [[nodiscard]] std::string toString() const noexcept;

private:
    explicit FuzzyReference(const std::optional<std::string> &channel,
                            const std::string &id,
                            const std::optional<std::string> &version,
                            const std::optional<Architecture> &arch);
};

} // namespace linglong::package
