% ll-builder 1

## NAME

ll-builder - Linyaps application build tool

## SYNOPSIS

**ll-builder** _subcommand_

## DESCRIPTION

ll-builder is a tool provided for application developers to build Linyaps applications. It supports building applications in isolated containers and includes a complete push and publish workflow.

Main features include:

- Building applications in isolated containers
- Complete application build, test, export, and publish workflow

## COMMANDS

| Command | Man Page                              | Description                                   |
| ------- | ------------------------------------- | --------------------------------------------- |
| create  | [ll-builder-create(1)](./create.md)   | Create Linyaps build template                 |
| build   | [ll-builder-build(1)](./build.md)     | Build Linyaps project                         |
| run     | [ll-builder-run(1)](./run.md)         | Run the built application                     |
| list    | [ll-builder-list(1)](./list.md)       | List built applications                       |
| remove  | [ll-builder-remove(1)](./remove.md)   | Remove built applications                     |
| export  | [ll-builder-export(1)](./export.md)   | Export Linyaps layer or UAB file              |
| push    | [ll-builder-push(1)](./push.md)       | Push Linyaps application to remote repository |
| import  | [ll-builder-import(1)](./import.md)   | Import Linyaps layer file to build repository |
| extract | [ll-builder-extract(1)](./extract.md) | Extract Linyaps layer file to directory       |
| repo    | [ll-builder-repo(1)](./repo.md)       | Display and manage repository                 |

## SEE ALSO

**[ll-builder-create(1)](./create.md)**, **[ll-builder-build(1)](./build.md)**, **[ll-builder-run(1)](./run.md)**, **[ll-builder-export(1)](./export.md)**, **[ll-builder-push(1)](./push.md)**

## HISTORY

Developed in 2023 by UnionTech Software Technology Co., Ltd.
