# 如意玲珑基础概念介绍

## Base

Base 可以理解为一个轻量化的“最小系统镜像”，包含操作系统核心组件（如glibc、bash等基础工具链），为应用提供跨发行版一致的底层依赖环境。它确保应用在不同 Linux 发行版（如 Debian、Ubuntu 等）上运行时，无需依赖宿主机的系统库，避免因环境差异导致的兼容性问题。

详细介绍见：[Base 组件](./runtime.md)。

## Runtime

Runtime 是应用运行时依赖的环境，它包含了应用运行所需的特定框架库。例如，某些应用可能依赖于特定的图形界面框架（如 DTK）、浏览器引擎（如 QT WebEngine）等，Runtime 就为这些应用提供了相应的运行环境支持，确保应用能够正常启动和运行。它与应用的基础运行环境 Base 相配合，共同确保应用能够在不同 Linux 发行版上稳定、高效地运行。Runtime 与 Base 采用层级依赖关系，应用必须先选择合适的 Base，再选择与之兼容的 Runtime。这种设计确保了应用在不同发行版上的跨发行版兼容性。

详细介绍见：[Runtime 组件](./runtime.md)。

## 沙箱

使用如意玲珑，每个应用程序都在一个称为“沙盒”的隔离环境中构建和运行。每个沙盒都包含Base、Runtime以及应用程序。
出于必要，沙盒内的一些资源需要被导出到主机系统以供使用。这些被称为“导出”的资源包括应用程序的桌面文件及其图标。

## 仓库

如意玲珑应用程序和运行时通常使用仓库进行存储和发布，其行为与Git仓库非常相似：一个如意玲珑仓库可以包含多个对象，每个对象都是版本化的，允许升级甚至降级。
每个使用如意玲珑的系统都可以配置为访问任意数量的远程仓库。一旦系统配置为访问一个‘远程’，就可以检查、搜索远程仓库的内容，并将其作为应用程序和运行时的来源。
当执行更新时，新版本的应用程序和运行时会从相关远程仓库下载。与Git类似，仅下载版本之间发生变化的部分，使该过程非常高效。
