/*
 * SPDX-FileCopyrightText: 2022 UnionTech Software Technology Co., Ltd.
 *
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#pragma once

#include "linglong/api/types/v1/PackageInfoV2.hpp"
#include "linglong/utils/error/error.h"

#include <QDir>

#include <filesystem>

namespace linglong::package {

class LayerDir : public QDir
{
public:
    using QDir::QDir;

    LayerDir(const std::filesystem::path &path)
        : QDir(QString::fromStdString(path.string()))
    {
    }

    LayerDir(const QString &path)
        : QDir(path)
    {
    }

    [[nodiscard]] utils::error::Result<api::types::v1::PackageInfoV2> info() const;
    [[nodiscard]] QString filesDirPath() const noexcept;
    [[nodiscard]] bool valid() const noexcept;
};

} // namespace linglong::package
