# OBS 上传指南

## ✅ 准备工作已完成

- [x] 版本号已更新到 1.6.6
- [x] spec 文件已修复
- [x] CMakeLists.txt 安装规则已完善
- [x] desktop 文件已复制到 debian 目录
- [x] OBS 打包文件已生成

---

## 📦 生成的文件

在 `obs_package/` 目录中：

1. **lz-scan-1.6.6.tar.gz** (6.8M) - 源码包
2. **debian.tar.gz** (2.4M) - Debian 打包文件
3. **lz-scan.dsc** (599 字节) - Debian 源码控制文件
4. **lz-scan.spec** (3.7K) - RPM spec 文件

---

## 🚀 上传到 OBS

### 方法 1: 使用 Web 界面（推荐）

#### 步骤 1: 登录 OBS
1. 访问 https://build.opensuse.org/
2. 使用你的账号登录

#### 步骤 2: 创建项目（如果还没有）
1. 点击 "Your Home Project"
2. 如果没有项目，点击 "Create Project"
3. 项目名称通常是 `home:你的用户名`

#### 步骤 3: 创建包
1. 在项目页面，点击 "Create Package"
2. 包名称: `lz-scan`
3. 标题: `亮仔扫描 - 现代化文档扫描应用`
4. 描述: 复制 spec 文件中的描述

#### 步骤 4: 上传文件
1. 进入包页面
2. 点击 "Add file"
3. 上传以下文件：
   - `lz-scan-1.6.6.tar.gz`
   - `lz-scan.spec`
   - `debian.tar.gz` (可选，用于 Debian 构建)
   - `lz-scan.dsc` (可选，用于 Debian 构建)

#### 步骤 5: 触发构建
1. 上传完成后，OBS 会自动触发构建
2. 在 "Build Results" 标签查看构建状态
3. 等待构建完成

---

### 方法 2: 使用 osc 命令行

#### 步骤 1: 安装 osc
```bash
# Debian/Ubuntu
sudo apt-get install osc

# openSUSE
sudo zypper install osc

# Fedora
sudo dnf install osc
```

#### 步骤 2: 配置 osc
```bash
# 首次使用需要配置
osc -A https://api.opensuse.org

# 输入你的 OBS 用户名和密码
```

#### 步骤 3: 检出项目
```bash
# 检出你的 home 项目
osc co home:你的用户名

# 进入目录
cd home:你的用户名
```

#### 步骤 4: 创建包
```bash
# 创建新包
osc mkpac lz-scan

# 进入包目录
cd lz-scan
```

#### 步骤 5: 复制文件
```bash
# 从项目根目录复制文件
cp /path/to/project/obs_package/* .

# 或者如果在项目根目录
cp obs_package/* home:你的用户名/lz-scan/
```

#### 步骤 6: 添加文件
```bash
# 添加所有文件
osc add *

# 或者单独添加
osc add lz-scan-1.6.6.tar.gz
osc add lz-scan.spec
```

#### 步骤 7: 提交
```bash
# 提交到 OBS
osc commit -m "Update to version 1.6.6

- 修复部分扫描仪扫描图像为全黑的问题
- 优化扫描数据读取逻辑
- 修复 ADF 多页扫描黑屏问题
- 性能提升 8.8 倍
"
```

#### 步骤 8: 查看构建状态
```bash
# 查看构建状态
osc results

# 查看构建日志
osc buildlog openSUSE_Tumbleweed x86_64
```

---

## 🔍 监控构建

### 查看构建状态

在 OBS 网页界面：
1. 进入你的包页面
2. 点击 "Build Results" 标签
3. 查看不同发行版和架构的构建状态

**状态说明**:
- 🟢 **succeeded** - 构建成功
- 🔵 **building** - 正在构建
- 🟡 **scheduled** - 等待构建
- 🔴 **failed** - 构建失败
- ⚪ **disabled** - 已禁用

### 查看构建日志

如果构建失败：
1. 点击失败的发行版/架构
2. 查看完整的构建日志
3. 查找错误信息（搜索 "error:"）

---

## 🐛 常见构建错误

### 错误 1: File not found

**错误信息**:
```
File not found: /usr/share/icons/hicolor/scalable/apps/lz-scan.svg
```

**原因**: CMakeLists.txt 没有安装该文件

**解决方案**: 
- 检查 CMakeLists.txt 的 install 规则
- 确保文件存在于源码包中

### 错误 2: Unpackaged files

**错误信息**:
```
Installed (but unpackaged) file(s) found:
   /usr/share/doc/lz-scan/README.md
```

**原因**: 安装了文件但没有在 spec 的 %files 中列出

**解决方案**: 在 spec 文件的 %files 部分添加：
```spec
%doc README.md
```

### 错误 3: BuildRequires 缺失

**错误信息**:
```
CMake Error: Could not find Qt5Core
```

**原因**: 缺少构建依赖

**解决方案**: 在 spec 文件中添加：
```spec
BuildRequires:  qt5-qtbase-devel
```

---

## ✅ 构建成功后

### 1. 下载构建的包

在 OBS 网页界面：
1. 进入包页面
2. 点击 "Download" 标签
3. 选择发行版和架构
4. 下载 RPM 或 DEB 包

### 2. 测试安装

```bash
# RPM 包
sudo rpm -ivh lz-scan-1.6.6-1.x86_64.rpm

# DEB 包
sudo dpkg -i lz-scan_1.6.6-1_amd64.deb
```

### 3. 发布到仓库

如果构建成功，可以：
1. 发布到 OBS 仓库
2. 用户可以通过包管理器安装
3. 自动更新

---

## 📊 支持的发行版

OBS 可以为多个发行版构建：

### openSUSE
- openSUSE Tumbleweed
- openSUSE Leap 15.5
- openSUSE Leap 15.6

### Fedora
- Fedora 39
- Fedora 40
- Fedora Rawhide

### Debian/Ubuntu
- Debian 11 (Bullseye)
- Debian 12 (Bookworm)
- Ubuntu 22.04 (Jammy)
- Ubuntu 24.04 (Noble)

### 其他
- Arch Linux
- CentOS Stream
- RHEL

---

## 💡 提示

### 1. 选择目标发行版

在项目设置中选择要构建的发行版：
1. 进入项目页面
2. 点击 "Repositories" 标签
3. 添加或删除发行版

### 2. 启用/禁用架构

可以选择构建的架构：
- x86_64 (64位)
- i586 (32位)
- aarch64 (ARM 64位)
- armv7l (ARM 32位)

### 3. 构建优先级

可以设置构建优先级，加快构建速度。

### 4. 自动更新

可以配置 GitHub webhook，自动触发 OBS 构建。

---

## 📝 检查清单

上传前确认：

- [x] 版本号一致（1.6.6）
- [x] spec 文件正确
- [x] 源码包完整
- [x] desktop 文件存在
- [x] 图标文件存在
- [x] man 手册存在
- [x] 本地编译成功

---

## 🎯 总结

### 当前状态
- ✅ 所有文件已准备就绪
- ✅ OBS 打包文件已生成
- ✅ 可以上传到 OBS

### 推荐步骤
1. 使用 Web 界面上传（更简单）
2. 上传 `lz-scan-1.6.6.tar.gz` 和 `lz-scan.spec`
3. 等待构建完成
4. 查看构建日志
5. 下载并测试构建的包

### 如果构建失败
1. 查看构建日志
2. 参考 `OBS编译问题分析.md`
3. 修复问题后重新上传

---

**文档版本**: 1.0  
**更新日期**: 2025年10月19日  
**状态**: 准备就绪
