# OBS 命令行快速参考

## 安装 osc

```bash
# Debian/Ubuntu
sudo apt-get install osc

# openSUSE
sudo zypper install osc

# Fedora
sudo dnf install osc

# Arch Linux
sudo pacman -S osc
```

---

## 配置 osc

```bash
# 首次配置
osc -A https://api.opensuse.org

# 查看配置
cat ~/.config/osc/oscrc
```

---

## 项目管理

```bash
# 检出项目
osc co home:你的用户名

# 创建新包
osc mkpac lz-scan

# 列出所有包
osc ls home:你的用户名

# 删除包
osc rdelete home:你的用户名 lz-scan
```

---

## 文件管理

```bash
# 添加文件
osc add lz-scan-1.6.6.tar.gz
osc add lz-scan.spec

# 添加所有文件
osc add *

# 删除文件
osc rm old-file.tar.gz

# 查看状态
osc status

# 查看差异
osc diff
```

---

## 提交更改

```bash
# 提交
osc commit -m "Update to 1.6.6"

# 提交所有更改
osc commit -m "Message" --all

# 查看提交历史
osc log
```

---

## 构建管理

```bash
# 查看构建状态
osc results

# 查看详细状态
osc results -v

# 查看特定仓库
osc results openSUSE_Tumbleweed

# 触发重新构建
osc rebuild openSUSE_Tumbleweed x86_64
```

---

## 构建日志

```bash
# 查看构建日志
osc buildlog openSUSE_Tumbleweed x86_64

# 实时跟踪日志
osc buildlog -f openSUSE_Tumbleweed x86_64

# 查看构建历史
osc buildhistory openSUSE_Tumbleweed x86_64

# 下载构建日志
osc buildlog openSUSE_Tumbleweed x86_64 > build.log
```

---

## 本地构建

```bash
# 本地构建（需要 osc-build）
osc build openSUSE_Tumbleweed x86_64

# 使用本地源码构建
osc build --local-package

# 清理构建环境
osc build --clean
```

---

## 仓库管理

```bash
# 查看仓库配置
osc meta prj home:你的用户名

# 编辑仓库配置
osc meta prj -e home:你的用户名

# 查看包元数据
osc meta pkg home:你的用户名 lz-scan

# 编辑包元数据
osc meta pkg -e home:你的用户名 lz-scan
```

---

## 下载构建结果

```bash
# 下载所有构建结果
osc getbinaries

# 下载特定仓库的结果
osc getbinaries openSUSE_Tumbleweed x86_64

# 下载到指定目录
osc getbinaries -d /tmp/packages
```

---

## 搜索

```bash
# 搜索包
osc search lz-scan

# 搜索项目
osc search --project lz-scan

# 搜索二进制包
osc search --binary lz-scan
```

---

## 信息查询

```bash
# 查看包信息
osc info home:你的用户名 lz-scan

# 查看项目信息
osc prjinfo home:你的用户名

# 查看构建配置
osc buildconfig openSUSE_Tumbleweed x86_64
```

---

## 常用组合命令

### 完整工作流

```bash
# 1. 检出项目
osc co home:你的用户名

# 2. 进入包目录
cd home:你的用户名/lz-scan

# 3. 更新文件
cp /path/to/new/lz-scan-1.6.6.tar.gz .
cp /path/to/new/lz-scan.spec .

# 4. 添加新文件
osc add lz-scan-1.6.6.tar.gz

# 5. 删除旧文件
osc rm lz-scan-1.6.5.tar.gz

# 6. 查看状态
osc status

# 7. 提交
osc commit -m "Update to 1.6.6"

# 8. 查看构建状态
osc results

# 9. 查看构建日志
osc buildlog openSUSE_Tumbleweed x86_64
```

### 快速更新

```bash
# 一键更新并提交
cd home:你的用户名/lz-scan
cp /path/to/obs_package/* .
osc add *
osc commit -m "Update to 1.6.6"
osc results
```

### 调试构建失败

```bash
# 1. 查看失败的构建
osc results | grep failed

# 2. 查看构建日志
osc buildlog openSUSE_Tumbleweed x86_64 | grep -i error

# 3. 本地重现
osc build openSUSE_Tumbleweed x86_64

# 4. 修复后重新构建
osc rebuild openSUSE_Tumbleweed x86_64
```

---

## 高级功能

### 分支项目

```bash
# 分支其他项目的包
osc branch openSUSE:Factory lz-scan

# 链接到其他包
osc linkpac openSUSE:Factory lz-scan home:你的用户名 lz-scan
```

### 请求合并

```bash
# 创建提交请求
osc submitrequest openSUSE:Factory

# 查看请求状态
osc request show 12345

# 接受请求
osc request accept 12345
```

### 维护更新

```bash
# 创建维护更新
osc mbranch openSUSE:Leap:15.6 lz-scan

# 提交维护更新
osc mr
```

---

## 配置选项

### ~/.config/osc/oscrc

```ini
[general]
apiurl = https://api.opensuse.org

[https://api.opensuse.org]
user = 你的用户名
pass = 你的密码
# 或使用密钥环
# keyring = 1

# 构建选项
build-root = /var/tmp/build-root
build-jobs = 4

# 代理设置（如需要）
# http_proxy = http://proxy:8080
# https_proxy = http://proxy:8080
```

---

## 快捷别名

添加到 `~/.bashrc` 或 `~/.zshrc`:

```bash
# OBS 别名
alias oscr='osc results'
alias oscb='osc buildlog'
alias oscc='osc commit'
alias oscs='osc status'
alias osca='osc add'

# 快速查看构建状态
alias oscrf='osc results | grep -E "(succeeded|failed|building)"'

# 快速查看错误
alias oscbe='osc buildlog openSUSE_Tumbleweed x86_64 | grep -i error'
```

---

## 故障排除

### 认证失败

```bash
# 重新配置
rm ~/.config/osc/oscrc
osc -A https://api.opensuse.org
```

### 构建卡住

```bash
# 取消构建
osc abortbuild openSUSE_Tumbleweed x86_64

# 重新触发
osc rebuild openSUSE_Tumbleweed x86_64
```

### 清理本地缓存

```bash
# 清理构建缓存
rm -rf ~/.cache/osc-build

# 清理下载缓存
rm -rf ~/.cache/osc
```

---

## 更多帮助

```bash
# 查看帮助
osc help

# 查看特定命令帮助
osc help commit
osc help build

# 查看所有命令
osc help commands
```

---

## 参考资源

- **osc 文档**: https://en.opensuse.org/openSUSE:OSC
- **OBS 文档**: https://openbuildservice.org/help/
- **man 手册**: `man osc`

---

**版本**: 1.0  
**更新**: 2025年10月19日
