# OBS 多发行版编译完整指南

## 📋 目录

1. [OBS 简介](#obs-简介)
2. [准备工作](#准备工作)
3. [创建 OBS 账号](#创建-obs-账号)
4. [创建项目](#创建项目)
5. [配置多发行版支持](#配置多发行版支持)
6. [上传源码包](#上传源码包)
7. [监控构建](#监控构建)
8. [发布到仓库](#发布到仓库)
9. [用户安装](#用户安装)

---

## OBS 简介

**Open Build Service (OBS)** 是一个开源的自动化构建系统，可以为多个 Linux 发行版自动构建软件包。

### 优势
- ✅ 自动为多个发行版构建（openSUSE、Fedora、Debian、Ubuntu 等）
- ✅ 自动为多个架构构建（x86_64、ARM、i586 等）
- ✅ 提供软件仓库，用户可以直接安装
- ✅ 自动处理依赖关系
- ✅ 免费使用

### 支持的发行版

#### openSUSE
- openSUSE Tumbleweed（滚动更新）
- openSUSE Leap 15.5
- openSUSE Leap 15.6

#### Fedora
- Fedora 39
- Fedora 40
- Fedora Rawhide

#### Debian
- Debian 11 (Bullseye)
- Debian 12 (Bookworm)
- Debian Testing

#### Ubuntu
- Ubuntu 20.04 LTS (Focal)
- Ubuntu 22.04 LTS (Jammy)
- Ubuntu 24.04 LTS (Noble)

#### 其他
- Arch Linux
- CentOS Stream 9
- RHEL 9

---

## 准备工作

### 1. 确保本地编译成功

```bash
# 清理并重新编译
rm -rf build
cmake -B build -S .
cmake --build build -j$(nproc)

# 测试运行
./build/lz-scan
```

### 2. 准备 OBS 打包文件

```bash
# 运行打包脚本
./package_for_obs.sh

# 检查生成的文件
ls -lh obs_package/
```

应该看到：
- `lz-scan-1.6.6.tar.gz` - 源码包
- `lz-scan.spec` - RPM spec 文件
- `debian.tar.gz` - Debian 打包文件
- `lz-scan.dsc` - Debian 源码控制文件

### 3. 验证打包文件

```bash
# 运行检查脚本
./check_obs_package.sh
```

确保所有检查通过。

---

## 创建 OBS 账号

### 步骤 1: 注册账号

1. 访问 https://build.opensuse.org/
2. 点击右上角 "Sign Up"
3. 填写注册信息：
   - Username（用户名）
   - Email（邮箱）
   - Password（密码）
4. 验证邮箱
5. 登录

### 步骤 2: 完善个人信息

1. 点击右上角用户名
2. 选择 "Configuration"
3. 填写个人信息

---

## 创建项目

### 方法 1: Web 界面创建（推荐新手）

#### 步骤 1: 创建 Home 项目

1. 登录后，点击 "Your Home Project"
2. 如果没有项目，会提示创建
3. 项目名称自动为 `home:你的用户名`
4. 点击 "Create Project"

#### 步骤 2: 创建包

1. 在项目页面，点击 "Create Package"
2. 填写信息：
   - **Name**: `lz-scan`
   - **Title**: `亮仔扫描 - 现代化文档扫描应用`
   - **Description**: 
     ```
     亮仔扫描是一个功能丰富的文档扫描应用程序，基于Qt5和SANE开发。
     
     主要功能：
     - 支持所有SANE兼容的扫描仪设备
     - 多种扫描模式：彩色、灰度、黑白
     - 强大的图像处理功能
     - 智能合并和拆分功能
     - 多页文档管理
     - 多种输出格式：PDF, PNG, JPEG, TIFF
     ```
3. 点击 "Save Changes"

#### 步骤 3: 上传文件

1. 进入包页面（`home:你的用户名/lz-scan`）
2. 点击 "Add file" 或 "Upload file"
3. 上传以下文件：
   - `lz-scan-1.6.6.tar.gz`（必需）
   - `lz-scan.spec`（必需）
   - `debian.tar.gz`（可选，用于 Debian/Ubuntu）
   - `lz-scan.dsc`（可选，用于 Debian/Ubuntu）

4. 上传完成后，OBS 会自动触发构建

---

### 方法 2: osc 命令行创建（推荐高级用户）

#### 步骤 1: 安装 osc

```bash
# Debian/Ubuntu
sudo apt-get install osc

# openSUSE
sudo zypper install osc

# Fedora
sudo dnf install osc

# Arch Linux
sudo pacman -S osc
```

#### 步骤 2: 配置 osc

```bash
# 首次使用需要配置
osc -A https://api.opensuse.org

# 输入你的 OBS 用户名和密码
# 配置文件保存在 ~/.config/osc/oscrc
```

#### 步骤 3: 检出项目

```bash
# 检出你的 home 项目
osc co home:你的用户名

# 如果项目不存在，会自动创建
```

#### 步骤 4: 创建包

```bash
# 进入项目目录
cd home:你的用户名

# 创建新包
osc mkpac lz-scan

# 进入包目录
cd lz-scan
```

#### 步骤 5: 复制文件

```bash
# 从项目根目录复制文件
cp /path/to/lz-scan/obs_package/* .

# 或者如果在项目根目录
cp obs_package/* ~/home:你的用户名/lz-scan/
```

#### 步骤 6: 添加文件到 OBS

```bash
# 添加所有文件
osc add *

# 或者单独添加
osc add lz-scan-1.6.6.tar.gz
osc add lz-scan.spec
osc add debian.tar.gz
osc add lz-scan.dsc
```

#### 步骤 7: 提交到 OBS

```bash
# 提交更改
osc commit -m "Initial import of lz-scan 1.6.6

- 现代化文档扫描应用
- 支持多种扫描模式
- 强大的图像处理功能
- 智能合并和拆分
"
```

#### 步骤 8: 查看构建状态

```bash
# 查看构建状态
osc results

# 查看详细构建日志
osc buildlog openSUSE_Tumbleweed x86_64

# 实时查看构建日志
osc buildlog -f openSUSE_Tumbleweed x86_64
```

---

## 配置多发行版支持

### 步骤 1: 添加仓库（Repositories）

#### Web 界面方式

1. 进入项目页面（`home:你的用户名`）
2. 点击 "Repositories" 标签
3. 点击 "Add from a Distribution"
4. 选择要支持的发行版：

**推荐配置**:

**openSUSE**:
- ✅ openSUSE Tumbleweed
- ✅ openSUSE Leap 15.6
- ✅ openSUSE Leap 15.5

**Fedora**:
- ✅ Fedora 40
- ✅ Fedora 39

**Debian**:
- ✅ Debian 12
- ✅ Debian 11

**Ubuntu**:
- ✅ Ubuntu 24.04
- ✅ Ubuntu 22.04
- ✅ Ubuntu 20.04

5. 点击 "Add selected repositories"

#### osc 命令行方式

编辑项目元数据：

```bash
# 编辑项目配置
osc meta prj -e home:你的用户名
```

添加仓库配置：

```xml
<project name="home:你的用户名">
  <title>My Home Project</title>
  <description>Personal packages</description>
  
  <!-- openSUSE Tumbleweed -->
  <repository name="openSUSE_Tumbleweed">
    <path project="openSUSE:Factory" repository="snapshot"/>
    <arch>x86_64</arch>
    <arch>i586</arch>
  </repository>
  
  <!-- openSUSE Leap 15.6 -->
  <repository name="openSUSE_Leap_15.6">
    <path project="openSUSE:Leap:15.6" repository="standard"/>
    <arch>x86_64</arch>
  </repository>
  
  <!-- Fedora 40 -->
  <repository name="Fedora_40">
    <path project="Fedora:40" repository="standard"/>
    <arch>x86_64</arch>
  </repository>
  
  <!-- Debian 12 -->
  <repository name="Debian_12">
    <path project="Debian:12" repository="standard"/>
    <arch>x86_64</arch>
  </repository>
  
  <!-- Ubuntu 24.04 -->
  <repository name="xUbuntu_24.04">
    <path project="Ubuntu:24.04" repository="standard"/>
    <arch>x86_64</arch>
  </repository>
  
  <!-- Ubuntu 22.04 -->
  <repository name="xUbuntu_22.04">
    <path project="Ubuntu:22.04" repository="standard"/>
    <arch>x86_64</arch>
  </repository>
</project>
```

保存后，OBS 会自动为所有配置的发行版构建。

### 步骤 2: 配置架构

可以为每个仓库配置支持的架构：

- **x86_64** - 64位 Intel/AMD（推荐）
- **i586** - 32位 Intel/AMD
- **aarch64** - 64位 ARM
- **armv7l** - 32位 ARM

**推荐配置**: 主要支持 x86_64

---

## 上传源码包

### 确保源码包正确

源码包应该包含：

```
lz-scan-1.6.6/
├── CMakeLists.txt
├── src/
│   ├── main.cpp
│   ├── mainwindow.cpp
│   ├── mainwindow.h
│   └── ...
├── resources/
│   └── resources.qrc
├── debian/
│   ├── changelog
│   ├── control
│   ├── copyright
│   ├── lz-scan.desktop
│   └── lz-scan.1
├── README.md
├── CHANGELOG.md
├── LICENSE
└── lz-scan.svg
```

### 验证源码包

```bash
# 解压检查
tar -tzf obs_package/lz-scan-1.6.6.tar.gz | head -20

# 确保目录结构正确
tar -tzf obs_package/lz-scan-1.6.6.tar.gz | grep "lz-scan-1.6.6/"
```

---

## 监控构建

### Web 界面监控

1. 进入包页面（`home:你的用户名/lz-scan`）
2. 点击 "Build Results" 标签
3. 查看各个发行版的构建状态

**状态说明**:
- 🟢 **succeeded** - 构建成功
- 🔵 **building** - 正在构建
- 🟡 **scheduled** - 等待构建
- 🟡 **blocked** - 被阻塞（等待依赖）
- 🔴 **failed** - 构建失败
- ⚪ **disabled** - 已禁用
- ⚪ **excluded** - 已排除

### 查看构建日志

如果构建失败：

1. 点击失败的发行版/架构
2. 查看完整的构建日志
3. 搜索 "error:" 查找错误信息

### osc 命令行监控

```bash
# 查看所有构建状态
osc results

# 查看特定发行版的构建日志
osc buildlog openSUSE_Tumbleweed x86_64

# 实时跟踪构建日志
osc buildlog -f Fedora_40 x86_64

# 查看构建历史
osc buildhistory openSUSE_Tumbleweed x86_64
```

---

## 常见构建问题和解决方案

### 问题 1: 依赖包名称不同

**错误**: `nothing provides qt5-qtbase-devel`

**原因**: 不同发行版的包名不同

**解决方案**: 在 spec 文件中使用条件判断

```spec
# openSUSE/Fedora
%if 0%{?suse_version} || 0%{?fedora}
BuildRequires:  qt5-qtbase-devel
%endif

# Debian/Ubuntu
%if 0%{?debian_version} || 0%{?ubuntu_version}
BuildRequires:  qtbase5-dev
%endif
```

### 问题 2: CMake 版本过低

**错误**: `CMake 3.10 or higher is required`

**解决方案**: 降低 CMake 版本要求或使用 backports

```cmake
# 降低版本要求
cmake_minimum_required(VERSION 3.5)
```

### 问题 3: 文件路径不同

**错误**: `File not found: /usr/share/icons/...`

**解决方案**: 使用 CMake 变量

```cmake
# 使用标准路径
install(FILES lz-scan.svg 
        DESTINATION ${CMAKE_INSTALL_DATADIR}/icons/hicolor/scalable/apps)
```

---

## 发布到仓库

### 步骤 1: 确认构建成功

确保所有目标发行版都构建成功（绿色 ✅）。

### 步骤 2: 发布项目

1. 进入项目页面
2. 点击 "Publish" 按钮
3. 等待发布完成

### 步骤 3: 获取仓库地址

发布后，可以获得仓库地址：

```
https://download.opensuse.org/repositories/home:/你的用户名/
```

---

## 用户安装

### openSUSE Tumbleweed

```bash
# 添加仓库
sudo zypper addrepo https://download.opensuse.org/repositories/home:/你的用户名/openSUSE_Tumbleweed/home:你的用户名.repo

# 刷新仓库
sudo zypper refresh

# 安装
sudo zypper install lz-scan
```

### openSUSE Leap 15.6

```bash
# 添加仓库
sudo zypper addrepo https://download.opensuse.org/repositories/home:/你的用户名/openSUSE_Leap_15.6/home:你的用户名.repo

# 刷新并安装
sudo zypper refresh
sudo zypper install lz-scan
```

### Fedora 40

```bash
# 添加仓库
sudo dnf config-manager --add-repo https://download.opensuse.org/repositories/home:/你的用户名/Fedora_40/home:你的用户名.repo

# 安装
sudo dnf install lz-scan
```

### Debian 12

```bash
# 添加仓库密钥
wget -qO - https://download.opensuse.org/repositories/home:/你的用户名/Debian_12/Release.key | sudo apt-key add -

# 添加仓库
echo 'deb https://download.opensuse.org/repositories/home:/你的用户名/Debian_12/ /' | sudo tee /etc/apt/sources.list.d/lz-scan.list

# 更新并安装
sudo apt-get update
sudo apt-get install lz-scan
```

### Ubuntu 24.04

```bash
# 添加仓库密钥
wget -qO - https://download.opensuse.org/repositories/home:/你的用户名/xUbuntu_24.04/Release.key | sudo apt-key add -

# 添加仓库
echo 'deb https://download.opensuse.org/repositories/home:/你的用户名/xUbuntu_24.04/ /' | sudo tee /etc/apt/sources.list.d/lz-scan.list

# 更新并安装
sudo apt-get update
sudo apt-get install lz-scan
```

### Ubuntu 22.04

```bash
# 添加仓库密钥
wget -qO - https://download.opensuse.org/repositories/home:/你的用户名/xUbuntu_22.04/Release.key | sudo apt-key add -

# 添加仓库
echo 'deb https://download.opensuse.org/repositories/home:/你的用户名/xUbuntu_22.04/ /' | sudo tee /etc/apt/sources.list.d/lz-scan.list

# 更新并安装
sudo apt-get update
sudo apt-get install lz-scan
```

---

## 创建安装说明页面

在项目 README 中添加安装说明：

```markdown
## 安装

### openSUSE

```bash
sudo zypper addrepo https://download.opensuse.org/repositories/home:/你的用户名/openSUSE_Tumbleweed/home:你的用户名.repo
sudo zypper refresh
sudo zypper install lz-scan
```

### Fedora

```bash
sudo dnf config-manager --add-repo https://download.opensuse.org/repositories/home:/你的用户名/Fedora_40/home:你的用户名.repo
sudo dnf install lz-scan
```

### Debian/Ubuntu

```bash
wget -qO - https://download.opensuse.org/repositories/home:/你的用户名/Debian_12/Release.key | sudo apt-key add -
echo 'deb https://download.opensuse.org/repositories/home:/你的用户名/Debian_12/ /' | sudo tee /etc/apt/sources.list.d/lz-scan.list
sudo apt-get update
sudo apt-get install lz-scan
```

更多发行版请访问: https://software.opensuse.org/download.html?project=home:你的用户名&package=lz-scan
```

---

## 高级功能

### 1. 自动更新

配置 GitHub webhook，当推送新代码时自动触发 OBS 构建。

### 2. 多项目管理

可以创建多个项目，例如：
- `home:你的用户名` - 稳定版
- `home:你的用户名:testing` - 测试版
- `home:你的用户名:devel` - 开发版

### 3. 协作开发

可以添加其他用户为项目维护者。

### 4. 构建优先级

可以设置构建优先级，加快构建速度。

---

## 最佳实践

### 1. 版本管理

- 使用语义化版本号（如 1.6.6）
- 每次发布更新 changelog
- 使用 Git 标签标记版本

### 2. 测试

- 本地测试所有目标发行版
- 使用 Docker 容器测试
- 在 OBS 上先测试一个发行版

### 3. 文档

- 提供清晰的安装说明
- 记录已知问题
- 提供用户支持渠道

### 4. 维护

- 定期更新依赖
- 修复构建失败
- 响应用户反馈

---

## 故障排除

### 构建一直处于 scheduled 状态

**原因**: 构建队列繁忙

**解决方案**: 耐心等待，通常几分钟到几小时

### 构建失败但日志不清楚

**解决方案**: 
1. 下载完整日志
2. 在本地 Docker 容器中重现
3. 查看 OBS 论坛

### 依赖问题

**解决方案**:
1. 检查 BuildRequires
2. 使用正确的包名
3. 添加额外的仓库

---

## 资源链接

- **OBS 官网**: https://build.opensuse.org/
- **OBS 文档**: https://openbuildservice.org/help/
- **OBS 论坛**: https://forums.opensuse.org/
- **软件下载页**: https://software.opensuse.org/

---

## 总结

通过 OBS，你可以：

1. ✅ 自动为多个 Linux 发行版构建软件包
2. ✅ 提供官方软件仓库
3. ✅ 让用户轻松安装和更新
4. ✅ 支持多种架构
5. ✅ 完全免费

**下一步**: 上传你的软件包到 OBS，开始构建！

---

**文档版本**: 1.0  
**更新日期**: 2025年10月19日  
**作者**: Kiro AI
