# 亮仔扫描 (lz-scan)

<div align="center">

![亮仔扫描](lz-scan.svg)

**现代化的 Linux 文档扫描应用**

基于 Qt5 与 SANE 开发，提供强大的图像处理和智能合并功能

[![Version](https://img.shields.io/badge/version-1.6.6-blue.svg)](https://github.com/tonglingcn/lz-scan/releases)
[![License](https://img.shields.io/badge/license-GPL--3.0-green.svg)](LICENSE)
[![Platform](https://img.shields.io/badge/platform-Linux-lightgrey.svg)](https://www.linux.org/)

[功能特性](#功能特性) • [快速开始](#快速开始) • [使用指南](#使用指南) • [文档](#文档) • [贡献](#贡献)

</div>

---

## 📋 目录

- [功能特性](#功能特性)
- [系统要求](#系统要求)
- [快速开始](#快速开始)
- [使用指南](#使用指南)
- [智能合并功能](#智能合并功能)
- [项目结构](#项目结构)
- [构建说明](#构建说明)
- [打包发布](#打包发布)
- [常见问题](#常见问题)
- [文档](#文档)
- [贡献指南](#贡献指南)
- [许可证](#许可证)
- [致谢](#致谢)

---

## ✨ 功能特性

### 🖨️ 扫描功能
- **设备支持**
  - 兼容所有 SANE 标准的 USB/网络扫描仪
  - 支持本地设备和网络设备自动发现
  - 智能设备名称显示和去重
  - 支持 ADF 自动进纸器和双面扫描

- **扫描模式**
  - 彩色、灰度、黑白多种模式
  - 可调分辨率（72-1200 DPI）
  - 预览扫描和正式扫描
  - 循环延时扫描（批量处理）

### 🎨 图像处理
- **基础操作**
  - 旋转（左转/右转/任意角度）
  - 交互式裁剪
  - 自动裁剪空白边缘

- **色彩调整**
  - 亮度/对比度调节
  - 色度/饱和度调节
  - 自动色阶
  - 灰度/二值化转换

- **高级处理**
  - 锐化和去噪
  - 文档增强
  - 背景漂白
  - 空白页自动检测

### 🔄 智能合并功能 (v1.6.5 新增)
- **智能拆分合并**
  - 自动检测图片中的多个内容区域
  - 支持所有 DPI（72-1200）和纸张尺寸
  - 左右合并/上下合并一键完成
  - 自动裁剪空白边缘

- **操作简化**
  - 选择2张图片 → 点击合并 → 选择方式 → 完成
  - 操作步骤从 6-8 步减少到 3 步
  - 无需手动拆分和裁剪

### 📄 文档管理
- **多页文档**
  - 页面插入、删除、排序
  - 页面预览和快速导航
  - 拖拽排序支持

- **导出格式**
  - PDF（单页/多页）
  - TIFF（单页/多页）
  - PNG、JPEG、BMP 等图片格式
  - 批量导出

### 🎯 用户体验
- **界面设计**
  - 现代化的用户界面
  - 中国红+金色传统风格图标
  - 实时预览和进度显示
  - 详细的状态栏反馈

- **操作便捷**
  - 撤销功能（最多10步）
  - 快捷键支持
  - 自动保存
  - 批量处理

---

## 💻 系统要求

### 运行环境
- **操作系统**: Linux（x86_64、ARM64、LoongArch64）
- **Qt 版本**: Qt 5.12 或更高版本
- **SANE 版本**: SANE 1.0 或更高版本
- **内存**: 建议 4GB 或以上

### 依赖库
- Qt5 Core、Gui、Widgets、PrintSupport、Concurrent
- libsane (SANE 后端库)
- 标准 C++ 库（支持 C++11）

---

## 🚀 快速开始

### 从源码构建

#### Debian/Ubuntu/Deepin
```bash
# 安装依赖
sudo apt-get update
sudo apt-get install -y build-essential cmake \
    qtbase5-dev qttools5-dev libsane-dev pkg-config

# 克隆仓库
git clone https://github.com/tonglingcn/lz-scan.git
cd lz-scan

# 构建
mkdir build && cd build
cmake ..
make -j$(nproc)

# 运行
./lz-scan
```

#### openSUSE
```bash
# 安装依赖
sudo zypper install -y gcc-c++ cmake \
    libqt5-qtbase-devel sane-backends-devel

# 构建（同上）
```

#### Fedora/RHEL
```bash
# 安装依赖
sudo dnf install -y gcc-c++ cmake \
    qt5-qtbase-devel sane-backends-devel

# 构建（同上）
```

### 安装二进制包

#### Debian/Ubuntu
```bash
# 下载 DEB 包
wget https://github.com/tonglingcn/lz-scan/releases/download/v1.6.5/lz-scan_1.6.5-1_amd64.deb

# 安装
sudo dpkg -i lz-scan_1.6.5-1_amd64.deb
sudo apt-get install -f  # 修复依赖
```

#### openSUSE
```bash
# 添加 OBS 仓库
sudo zypper addrepo https://download.opensuse.org/repositories/home:/你的用户名/openSUSE_Tumbleweed/ lz-scan

# 安装
sudo zypper refresh
sudo zypper install lz-scan
```

### 权限配置
```bash
# 将用户添加到 scanner 组
sudo usermod -a -G scanner $USER

# 重新登录使权限生效
```

---

## 📖 使用指南

### 基本扫描流程

1. **启动应用**
   ```bash
   lz-scan
   ```

2. **查找设备**
   - 点击工具栏的"查找设备"按钮
   - 选择本地设备或网络设备
   - 等待设备初始化完成

3. **配置扫描参数**
   - 分辨率：72-1200 DPI
   - 色彩模式：彩色/灰度/黑白
   - 纸张来源：平板/ADF
   - 双面扫描：单面/双面

4. **执行扫描**
   - 点击"预览"查看效果
   - 点击"扫描"开始正式扫描
   - 查看扫描结果

5. **图像处理**
   - 旋转：调整图片方向
   - 裁剪：去除多余部分
   - 增强：优化图像质量

6. **保存文档**
   - 单页保存：保存当前图片
   - 多页保存：保存为 PDF 或 TIFF
   - 选择保存位置和格式

### 智能合并功能使用

#### 场景1：身份证正反面合并
```
1. 扫描身份证正面和反面（两张图片）
2. 按住 Shift 键选择这2张图片
3. 点击工具栏"合并图片"按钮
4. 选择"左右合并"
5. 勾选"智能拆分图片"和"自动裁剪空白边缘"
6. 点击确定
→ 自动完成拆分、裁剪、合并
```

#### 场景2：户口本页面合并
```
1. 扫描户口本两页（两张图片）
2. 按住 Shift 键选择这2张图片
3. 点击工具栏"合并图片"按钮
4. 选择"上下合并"
5. 勾选"智能拆分图片"和"自动裁剪空白边缘"
6. 点击确定
→ 自动完成拆分、裁剪、合并
```

### 批量扫描

#### 循环延时扫描
```
1. 点击"延时扫描"按钮
2. 选择延时间隔（3/6/9/15/20秒）
3. 放好第一张原稿
4. 倒计时结束后自动扫描
5. 在倒计时期间放好下一张原稿
6. 重复直到所有原稿扫描完成
7. 点击"扫描完成"按钮
8. 保存所有扫描的图片
```

---

## 🔄 智能合并功能

### 功能亮点
- **智能检测**: 自动检测图片中的多个内容区域
- **通用支持**: 支持所有 DPI（72-1200）和纸张尺寸
- **自动处理**: 自动拆分、裁剪、合并，无需手动操作
- **操作简单**: 3步完成，从选择到合并

### 支持的 DPI
| DPI | A4像素尺寸 | 支持状态 |
|-----|-----------|---------|
| 72  | 595×842   | ✓ 支持 |
| 96  | 794×1123  | ✓ 支持 |
| 150 | 1240×1754 | ✓ 支持 |
| 200 | 1654×2339 | ✓ 支持 |
| 300 | 2480×3508 | ✓ 支持 |
| 600 | 4961×7016 | ✓ 支持 |
| 1200| 9921×14032| ✓ 支持 |

### 技术原理
```cpp
// 基于内容区域检测，不依赖图片尺寸
QVector<QRect> contentBounds = 
    m_imageProcessor->detectMultipleContentBounds(image, isHorizontal, 240);

if (contentBounds.size() >= 2) {
    // 检测到多个内容区域，触发自动拆分
    // 拆分 → 保留需要的部分 → 裁剪空白 → 合并
}
```

---

## 📁 项目结构

```
lz-scan/
├── src/                          # 源代码
│   ├── main.cpp                  # 程序入口
│   ├── mainwindow.*              # 主窗口
│   ├── scannercontroller.*      # 扫描仪控制
│   ├── imageprocessor.*         # 图像处理
│   ├── documentmanager.*        # 文档管理
│   ├── croppableimagewidget.*   # 裁剪控件
│   └── platform_detection.*     # 平台检测
├── resources/                    # 资源文件
│   ├── icons/                    # 图标
│   └── resources.qrc             # Qt 资源
├── icons/                        # 应用图标
│   ├── standard/                 # 标准图标
│   └── hicolor/                  # 多尺寸图标
├── debian/                       # Debian 打包
│   ├── control                   # 包控制文件
│   ├── changelog                 # 变更日志
│   └── rules                     # 构建规则
├── obs_package/                  # OBS 打包
├── CMakeLists.txt               # CMake 配置
├── build_deb.sh                 # DEB 构建脚本
├── package_for_obs.sh           # OBS 打包脚本
├── lz-scan.spec                 # RPM 规格文件
├── README.md                    # 本文件
├── LICENSE                      # GPL-3.0 许可证
└── CHANGELOG.md                 # 完整变更日志
```

---

## 🔨 构建说明

### CMake 配置
```cmake
project(lz-scan VERSION 1.6.5 LANGUAGES CXX)
set(CMAKE_CXX_STANDARD 11)
set(CMAKE_AUTOMOC ON)
set(CMAKE_AUTORCC ON)
set(CMAKE_AUTOUIC ON)
```

### 构建选项
```bash
# 调试构建
cmake -DCMAKE_BUILD_TYPE=Debug ..

# 发布构建
cmake -DCMAKE_BUILD_TYPE=Release ..

# 指定安装前缀
cmake -DCMAKE_INSTALL_PREFIX=/usr ..
```

### 安装
```bash
sudo make install
```

---

## 📦 打包发布

### Debian/Ubuntu 包
```bash
# 构建 DEB 包
./build_deb.sh

# 生成的文件
../lz-scan_1.6.5-1_amd64.deb
```

### openSUSE Build Service
```bash
# 准备 OBS 包
./package_for_obs.sh

# 生成的文件
obs_package/lz-scan-1.6.5.tar.gz
obs_package/debian.tar.gz
obs_package/lz-scan.dsc
obs_package/lz-scan.spec
```

### RPM 包
```bash
# 使用 rpmbuild
rpmbuild -ba lz-scan.spec
```

---

## ❓ 常见问题

### 设备相关

**Q: 找不到扫描仪设备？**
```bash
# 检查 SANE 是否能识别设备
scanimage -L

# 检查用户权限
groups | grep scanner

# 添加用户到 scanner 组
sudo usermod -a -G scanner $USER
```

**Q: 网络设备无法连接？**
```bash
# 检查网络设备配置
cat /etc/sane.d/net.conf

# 添加网络设备
echo "192.168.1.100" | sudo tee -a /etc/sane.d/net.conf
```

### 扫描相关

**Q: 扫描速度慢？**
- 降低扫描分辨率（300 DPI 通常足够）
- 使用灰度模式代替彩色模式
- 关闭不必要的图像处理选项

**Q: 图像质量差？**
- 提高扫描分辨率
- 使用文档增强功能
- 调整亮度和对比度

### 合并相关

**Q: 智能拆分不工作？**
- 确保图片包含明显的多个内容区域
- 检查是否勾选了"智能拆分图片"选项
- 如果拆分失败，程序会自动使用原图并裁剪空白

**Q: 合并后图片变形？**
- 这个问题在 v1.6.5 已修复
- 确保使用最新版本
- 启用"自动裁剪空白边缘"选项

---

## 📚 文档

### 用户文档
- [快速开始指南](快速开始_v1.6.1.md)
- [智能合并功能说明](智能拆分合并功能使用说明.md)
- [空白页检测说明](空白页检测优化_v1.6.2.md)

### 开发文档
- [架构说明](arch.md)
- [项目总结](PROJECT_SUMMARY.md)
- [功能实现说明](功能实现说明.md)

### 版本文档
- [版本发布说明 v1.6.5](版本发布_v1.6.5.md)
- [完整变更日志](CHANGELOG.md)
- [版本更新总结](版本更新总结_v1.6.5.md)

---

## 🤝 贡献指南

我们欢迎各种形式的贡献！

### 如何贡献

1. **Fork 项目**
   ```bash
   git clone https://github.com/你的用户名/lz-scan.git
   ```

2. **创建特性分支**
   ```bash
   git checkout -b feature/amazing-feature
   ```

3. **提交更改**
   ```bash
   git commit -m "feat: 添加某个很棒的功能"
   ```

4. **推送到分支**
   ```bash
   git push origin feature/amazing-feature
   ```

5. **创建 Pull Request**

### 提交规范
- `feat`: 新功能
- `fix`: 修复 bug
- `docs`: 文档更新
- `style`: 代码格式调整
- `refactor`: 代码重构
- `test`: 测试相关
- `chore`: 构建/工具相关

### 代码规范
- 遵循 C++11 标准
- 使用 Qt 编码规范
- 添加必要的注释
- 保持代码整洁

---

## 📄 许可证

本项目采用 **GPL-3.0** 许可证发布。详见 [LICENSE](LICENSE) 文件。

### 主要条款
- ✅ 可以自由使用、修改和分发
- ✅ 可以用于商业目的
- ⚠️ 修改后的代码必须开源
- ⚠️ 必须保留原作者版权信息
- ⚠️ 分发时必须提供源代码

### 第三方许可
- **Qt 5**: LGPL-3.0（使用系统动态库）
- **SANE**: GPL 系列许可证
- 详见 [THIRD_PARTY_NOTICES.md](THIRD_PARTY_NOTICES.md)

---

## 🙏 致谢

### 开源项目
- [SANE Project](http://www.sane-project.org/) - 扫描仪访问标准
- [Qt Project](https://www.qt.io/) - 跨平台应用框架

### 贡献者
感谢所有为本项目做出贡献的开发者和用户！

### 特别感谢
- 深度论坛用户的反馈和建议
- 所有提交 Issue 和 PR 的贡献者
- 提供设备兼容性测试的用户

---

## 📞 联系方式

### 问题反馈
- **GitHub Issues**: https://github.com/tonglingcn/lz-scan/issues
- **邮件支持**: 315707022@qq.com

### 项目主页
- **GitHub**: https://github.com/tonglingcn/lz-scan
- **Releases**: https://github.com/tonglingcn/lz-scan/releases

---

## 📊 项目状态

- **当前版本**: 1.6.5
- **开发状态**: 活跃开发中
- **维护状态**: 积极维护
- **最后更新**: 2025年10月12日

---

<div align="center">

**亮仔扫描 - 让扫描更智能，让操作更简单！**

Made with ❤️ by 克亮

[⬆ 回到顶部](#亮仔扫描-lz-scan)

</div>
