# 亮仔扫描 (lz-scan) 架构文档

版本：1.5.0
更新时间：2025-10-03

## 1. 项目概览

亮仔扫描 (lz-scan) 是一个基于 Qt5 Widgets 与 SANE 的现代化文档扫描应用，专为 Linux 桌面环境设计，提供扫描、图像处理、多页文档管理与多格式导出等能力。

- 扫描后端：SANE (libsane)
- UI/运行时：Qt5 Core/Gui/Widgets/PrintSupport/Concurrent
- 主要功能：
  - 设备发现、选择、参数配置（分辨率/色彩模式/纸张来源/双面）
  - 预览扫描、普通扫描、延时循环扫描、ADF 多页扫描
  - 图像处理（旋转、裁剪、亮度/对比度、自动色阶、锐化、降噪、灰度/二值化、自动纠偏、文本增强、去边框、背景漂白、色相/饱和度）
  - 文档管理（多页、重排、删除、右键菜单快捷操作）
  - 多格式导出（PDF、PNG、JPEG、BMP、TIFF，多页 PDF/TIFF）与自动保存
- 构建系统：CMake 3.10+
- 语言/标准：C++/C++11
- 平台支持：Linux（已适配多 CPU 架构检测）

参考：CMakeLists.txt、src/*.cpp|h、resources/resources.qrc、debian/*、obs_package/*、脚本 build_*.sh。

## 2. 架构总览

系统采用“主窗体协调器 + 设备控制器 + 图像处理器 + 文档管理 + 后台扫描工人”分层解耦模式，UI 与长耗时任务通过信号/槽与工作线程隔离。

```mermaid
graph TD
    UI[MainWindow] --> SC[ScannerController]
    UI --> IP[ImageProcessor]
    UI --> DM[DocumentManager]
    UI --> CIW[CroppableImageWidget]
    SC -- 信号/槽 --> SW[ScanWorker@QThread]
    SC --> SANE[libsane]
    IP --> ALG[图像处理算法]
    DM --> IO[文件I/O(PDF/TIFF/IMG)]
    UI --> PD[PlatformDetection]
```

核心目标：在保持 UI 响应的同时，提供稳定可控的扫描与图像处理体验，并确保文档导出一致性与可追溯性。

## 3. 模块职责与接口

### 3.1 MainWindow (src/mainwindow.{h,cpp})
- 职责：顶层协调器与 UI 容器，负责菜单/工具栏/状态栏/停靠面板、参数控件（分辨率、色彩模式、纸张来源、双面等）、页面列表与图像展示。
- 关键能力：
  - 设备工作流：查找设备、选择设备、参数更新、开始/取消扫描、预览
  - 扫描模式：普通扫描、预览、延时循环扫描（倒计时触发多次扫描、手动“扫描完成”结束）、ADF 多页扫描
  - 图像处理：旋转/裁剪/亮度对比度/自动色阶/灰度/二值/自动纠偏/文本增强/去边框/背景漂白/色相饱和度
  - 文档操作：新建/打开/保存/导出/保存为多页 PDF、右键菜单（添加/插入/删除/清空）
  - 撤销栈：QStack<QImage>，最多 10 步
  - 自动保存：可开启/关闭，计数器与批量保存
- 主要槽函数：onScanButtonClicked/onPreviewButtonClicked/onDelayScanButtonClicked/onFinishDelayScanClicked/onScannerSelected/onScanProgress/onScanComplete/onScanError 等

### 3.2 ScannerController (src/scannercontroller.{h,cpp})
- 职责：与 SANE 交互的中介层，管理设备发现、选择、参数、支持能力（ADF/双面），并通过工作线程执行扫描。
- 状态与能力：
  - 初始化状态机：NotInitialized/Initializing/Initialized/InitializationFailed
  - 设备缓存：m_cachedScanners 显著降低重复枚举开销
  - 能力探测：detectADFSupport() 枚举 SANE 选项，解析 source/duplex 等，识别选项活跃状态，构建 availablePaperSources 与 availableDuplexModes
- 线程模型：
  - m_workerThread 常驻，ScanWorker moveToThread
  - startScanWorker/cancelScanWorker 信号触发后台扫描
  - 将 ScanWorker 的进度/完成/错误信号转发到 UI 层
- 主要接口：
  - 设备：getAvailableScanners()/refreshScanners()/selectScanner()/isScannerAvailable()
  - 参数：setResolution/setColorMode/setScanArea/setPageSize/setPaperSource/setDuplexMode
  - 扫描：startScan/startPreview/cancelScan；multiPageScanStarted/currentPageScanning/multiPageScanFinished 信号

### 3.3 ScanWorker (ScannerController 内部类)
- 职责：运行在专用 QThread 内，直接调用 SANE API 完成读流、分页、多面/双面逻辑。
- 关键流程：openDevice → setOptions → performScan/performMultiPageScan → readScanData → closeDevice
- 信号：scanProgress/scanComplete/scanError，multiPageScanStarted/currentPageScanning/multiPageScanFinished
- 终止控制：cancelScan() 置位取消标记，读取循环与 I/O 及时响应

### 3.4 ImageProcessor (src/imageprocessor.{h,cpp})
- 职责：提供图像处理算子，面向文档增强场景优化。
- 能力：
  - 基础：rotateLeft/Right、crop、adjustBrightnessContrast、adjustHueSaturation
  - 增强：autoLevel、sharpen、denoise、convertToGrayscale、convertToBinary
  - 文档：deskew（增强版含直线/文字双路径角度估计与结果融合）、rotateByAngle、removeBorder、enhanceText、bleachBackground
- 进度回调：处理大图时按行触发 processingProgress，保障 UI 可响应

### 3.5 DocumentManager (src/documentmanager.{h,cpp})
- 职责：多页文档数据结构与 I/O，维护 m_pages、当前页、文件路径、标题与“是否有未保存更改”。
- 能力：
  - 文档：new/load/save/export，支持 PNG/JPG/JPEG/BMP/TIFF/TIF/PDF
  - 多页：add/insert/remove/moveUp/moveDown，currentPageChanged/pageAdded/pageRemoved/pageMoved 信号
  - 导出：saveAsPDF（按首图尺寸设 PDF PageSize、300DPI）、saveAsMultiPageTIFF、saveAsImage（多文件）

### 3.6 CroppableImageWidget (src/croppableimagewidget.{h,cpp})
- 职责：交互式裁剪控件，鼠标选择裁剪区域，实时可视反馈，输出 QRect 裁剪框

### 3.7 Platform Detection (src/platform_detection.{h,cpp})
- 职责：编译期/运行时平台画像输出，包含架构/OS/编译器/字节序与 SIMD 能力宏，启动时打印平台信息（scanx_print_platform_info）
- 支持架构：x86_64、ARM64、LoongArch64、ARM32、x86_32

### 3.8 资源系统 (resources/resources.qrc)
- 职责：统一管理 SVG 图标等资源，通过 Qt 资源系统嵌入可执行文件，避免运行时路径问题

### 3.9 品牌配置（ScannerBrandProfile，src/scannerbrandprofile.{h,cpp}）
- 职责：按厂商/机型提供默认参数、特性开关与推荐提示（如 Epson/HP/Canon/…）
- 能力：品牌检测、模式化默认参数、quirks 处理（源选项非活跃、需要色彩校正表、ADF 探测慢等）

## 4. 运行时流程

### 4.1 启动流程
```mermaid
sequenceDiagram
    participant OS
    participant App as QApplication
    participant MW as MainWindow
    participant PD as PlatformDetection

    OS->>App: 启动
    App->>PD: 打印平台信息
    App->>MW: 构造/展示主窗体
    MW->>MW: 初始化UI/信号槽/状态
```

### 4.2 设备发现与选择
```mermaid
sequenceDiagram
    participant MW
    participant SC as ScannerController

    MW->>SC: initializeAsync/ensureInitialized
    MW->>SC: refreshScanners
    SC-->>MW: 可用设备列表
    MW->>SC: selectScanner(displayName)
    SC->>SC: detectADFSupport()/updateScannerParameters
    SC-->>MW: supportsADF/duplex + 参数区更新
```

### 4.3 扫描/预览
```mermaid
sequenceDiagram
    participant MW
    participant SC
    participant SW as ScanWorker(QThread)
    participant SANE

    MW->>SC: startScan/preview(参数)
    SC-->>SW: startScanWorker(device,mode,dpi,source,duplex)
    SW->>SANE: sane_open/sane_start
    loop 读数据
        SW->>SANE: sane_read
        SANE-->>SW: 数据块
        SW-->>SC: scanProgress
        SC-->>MW: scanProgress
    end
    SW-->>SC: scanComplete(QImage)
    SC-->>MW: scanComplete(QImage)
    MW->>MW: 显示/入文档/自动保存
```

### 4.4 延时循环扫描
- 入口：onDelayScanButtonClicked → 弹窗选择时间间隔（3/6/9/15/20s），进入“延时扫描模式”
- 机制：QTimer 每秒减少倒计时，至 0 触发一次扫描并累加计数；“扫描完成”按钮可随时结束并询问保存多页或单页
- 自动保存：延时模式下默认禁用自动保存，结束后恢复

### 4.5 ADF 多页/双面
- supportsADF() 与 supportsDuplex() 基于 SANE 选项表探测
- performMultiPageScan() 驱动分页与 currentPageScanning/page 计数信号

### 4.6 图像处理
- MainWindow 触发 ImageProcessor 算子，按行回调进度，完成后更新当前页与撤销栈

### 4.7 文档保存与导出
- 单页：保存为图片/PDF
- 多页：保存为单个 PDF 或多页 TIFF，或分散为多个图片文件

## 5. 线程与并发模型
- UI 线程：MainWindow、参数控件、页面列表与图像显示
- 后台线程：ScanWorker 专用 QThread，封装 SANE I/O、分页与数据合成
- 信号/槽：跨线程自动排队，保证线程安全；取消扫描通过标志位与条件变量协作
- 进度反馈：扫描与处理均周期性发出进度，避免 UI 卡顿

## 6. 参数与设备能力管理
- 扫描参数：resolution/colorMode/scanArea/pageSize/paperSource/duplexMode
- 设备能力：
  - 纸张来源（Flatbed/ADF/Feeder/...），基于 SANE 约束字符串列表解析；仅在选项活跃时认定支持
  - 双面模式（Simplex/Duplex*），按设备约束动态生成可用列表
- 品牌特性：ScannerBrandProfile 提供默认参数与 quirks，为特定品牌设备改善体验

## 7. 资源与平台适配
- 资源：qrc 内嵌 SVG 图标（扫描/裁剪/旋转/撤销/增强等），打包为单一可执行
- 平台检测：在启动时输出架构、OS、编译器、字节序与 SIMD 提示，便于调试与多架构发布

## 8. 构建与打包
- CMake 构建：
  - 自动开启 AUTOMOC/AUTORCC/AUTOUIC
  - 链接 Qt5 与 SANE 库
  - install(TARGETS lz-scan DESTINATION bin)
- 发行打包：
  - Debian：debian/control、rules、changelog、.install、postinst/postrm/prerm、man 手册页（debian/lz-scan.1）
  - OBS/RPM：obs_package 下 spec/dsc/debian.tar.gz 等
  - 脚本：build_deb.sh、build_multiarch.sh、package_for_obs.sh、prepare_for_github.sh 等
- 多架构：平台检测模块已覆盖 x86_64/ARM64/LoongArch64 等，配合多架构构建脚本实现产物发布

## 9. 错误处理与可用性
- 设备连接失败/超时/被占用：统一弹窗/状态栏消息提示与调试日志
- 参数非法：范围裁剪与默认值回退（如亮度/对比度/阈值等）
- 读流失败：及时 cancel/close 并提示
- UI 反馈：状态栏消息、进度条、对话框

## 10. 性能与内存
- 大图处理：逐行访问与进度回调，避免长时间阻塞
- 去噪/锐化：可控强度与核尺寸，防止过度计算
- 多页合成：PDF/TIFF 逐页绘制/写入，降低峰值内存
- 设备枚举缓存：减少重复枚举 SANE 设备开销

## 11. 安全与稳定性
- 运行时输入验证：文件路径/扩展名校验，受支持格式白名单
- 外部接口：仅依赖系统 SANE 与 Qt 官方 API
- 线程安全：跨线程信号槽、取消标志、Mutex/WaitCondition 防止竞态

## 12. 目录结构（关键项）

- src/
  - main.cpp：应用入口、平台信息打印、MainWindow 启动
  - mainwindow.{h,cpp}：主窗体与业务协调
  - scannercontroller.{h,cpp}：SANE 控制与线程调度
  - imageprocessor.{h,cpp}：图像处理算子
  - documentmanager.{h,cpp}：多页文档与导出
  - croppableimagewidget.{h,cpp}：交互裁剪
  - platform_detection.{h,cpp}：平台检测与日志
  - scannerbrandprofile.{h,cpp}：品牌与推荐参数
- resources/resources.qrc：图标等资源
- debian/*：Deb 打包元数据与脚本
- obs_package/*：OBS/RPM 相关打包文件
- 脚本：build_deb.sh、build_multiarch.sh 等

## 13. 扩展点与演进
- OCR：接入 OCR 引擎（本地/可选插件）输出可搜索 PDF
- 插件化：对图像处理与导出流程开放插件接口
- 扫描后流程：工作流化（命名规则/批量导出/云同步）
- Flatpak/其他包：补充多渠道发布
- 自动化质量：加入单元测试、CI 构建与静态检查

## 14. 接口契约（摘要）
- ScannerController：
  - 输入：displayName/参数（mode/dpi/source/duplex/area）
  - 输出：scanProgress(int)/scanComplete(QImage)/scanError(QString)、多页相关信号
  - 约束：调用前需 ensureInitialized 且 selectScanner 成功
- ImageProcessor：
  - 输入：QImage + 参数（范围限制与默认）
  - 输出：处理后 QImage + processingProgress 回调
- DocumentManager：
  - 输入：图像/导出路径/格式
  - 行为：单页/多页统一保存入口，失败回调 documentError

---

本架构文档基于工程源码与构建脚本实证分析编写，可作为开发、调试、打包与发布的统一参考。