# 扫描设置图标说明

## 图标文件

为"扫描设置"功能设计了4个版本的图标：

### 1. scan-search.svg (24x24) ⭐ 推荐
- **用途**：工具栏按钮
- **风格**：扫描仪 + 搜索放大镜
- **特点**：
  - 清晰表达"搜索扫描仪"的功能
  - 扫描仪主体 + 搜索图标
  - 简洁现代
  - 小尺寸下效果好

### 2. scan-settings.svg (24x24)
- **用途**：备选方案
- **风格**：扫描仪 + 设置齿轮
- **特点**：
  - 扫描仪 + 黄色齿轮
  - 表达"扫描设置"
  - 与高级设置区分（齿轮位置不同）

### 3. scan-network.svg (24x24)
- **用途**：强调网络功能
- **风格**：扫描仪 + 网络信号波纹
- **特点**：
  - 扫描仪 + 蓝色WiFi波纹
  - 强调网络扫描功能
  - 适合网络设备场景

### 4. scan-connection.svg (24x24)
- **用途**：完整功能展示
- **风格**：扫描仪 + USB + WiFi
- **特点**：
  - 同时显示USB和WiFi图标
  - 完整表达两种连接方式
  - 信息量大

## 设计理念

### 视觉元素

```
scan-search.svg (推荐):
┌─────────┐
│ ┌─┐     │  ← 扫描仪盖子
│ │ │ ─── │  ← 蓝色扫描线
│ │●│ □   │  ← 指示灯和纸张
│ └─┘     │
│      🔍 │  ← 搜索放大镜
└─────────┘
```

### 颜色方案

- **扫描仪主体**：浅灰 (#f8f9fa)
- **边框**：深灰 (#495057)
- **扫描线**：蓝色 (#00BFFF)
- **指示灯**：绿色 (#28a745)
- **搜索图标**：蓝色 (#00BFFF)

## 与其他图标的区别

### 高级设置 vs 扫描设置

| 图标 | 元素 | 功能 |
|------|------|------|
| 高级设置 | 齿轮 | 图像处理设置 |
| 扫描设置 | 扫描仪+搜索 | 扫描仪搜索设置 |

**视觉区分**：
- 高级设置：纯齿轮图标
- 扫描设置：扫描仪+搜索放大镜

## 使用建议

### 推荐使用：scan-search.svg

**原因**：
1. ✅ 清晰表达"搜索扫描仪"功能
2. ✅ 与高级设置图标明显区分
3. ✅ 简洁现代，易于识别
4. ✅ 小尺寸下效果好

### 其他场景

- **强调网络功能**：使用 scan-network.svg
- **强调设置功能**：使用 scan-settings.svg
- **完整展示**：使用 scan-connection.svg

## 在资源文件中使用

### 添加到 resources.qrc

```xml
<RCC>
    <qresource prefix="/icons">
        <!-- 其他图标... -->
        <file>../icons/scan-search.svg</file>
        <file>../icons/scan-settings.svg</file>
        <file>../icons/scan-network.svg</file>
        <file>../icons/scan-connection.svg</file>
    </qresource>
</RCC>
```

### 在代码中使用

```cpp
// 推荐使用
QAction *scanSettingsAction = 
    new QAction(QIcon(":/icons/scan-search.svg"), tr("扫描设置"), this);

// 或其他版本
QAction *scanSettingsAction = 
    new QAction(QIcon(":/icons/scan-network.svg"), tr("扫描设置"), this);
```

## 图标预览

### scan-search.svg (推荐)
```
特点：扫描仪 + 搜索放大镜
适用：工具栏按钮
尺寸：24x24
风格：简洁现代
```

### scan-settings.svg
```
特点：扫描仪 + 黄色齿轮
适用：设置相关
尺寸：24x24
风格：功能明确
```

### scan-network.svg
```
特点：扫描仪 + WiFi波纹
适用：网络功能
尺寸：24x24
风格：强调网络
```

### scan-connection.svg
```
特点：扫描仪 + USB + WiFi
适用：完整展示
尺寸：24x24
风格：信息丰富
```

## 技术规格

### SVG 优点
- 矢量图形，任意缩放不失真
- 文件小（< 2KB）
- 支持 CSS 样式修改
- Qt 原生支持

### 颜色代码
```css
/* 扫描仪 */
--scanner-body: #f8f9fa;
--scanner-border: #495057;
--scan-line: #00BFFF;
--indicator: #28a745;

/* 搜索/网络 */
--search-icon: #00BFFF;
--wifi-signal: #00BFFF;

/* 设置齿轮 */
--gear-color: #ffc107;
```

## 自定义修改

如果需要修改图标：

1. **改变颜色**
   - 编辑 SVG 文件中的 `fill` 和 `stroke` 属性

2. **调整大小**
   - 修改 `viewBox` 属性
   - 保持宽高比

3. **添加元素**
   - 在 SVG 中添加新的 `<g>` 组
   - 保持整体风格一致

## 版本历史

- **v1.0** (2025) - 初始设计
  - 创建 4 个不同版本
  - 适配不同使用场景
  - 统一设计语言

## 许可证

这些图标遵循项目的开源许可证。

## 反馈

如果对图标有任何建议，请提出反馈。

---

**设计者**：AI Assistant (Kiro)  
**创建日期**：2025年  
**推荐使用**：scan-search.svg
