#!/bin/bash

# 亮仔扫描 图标安装脚本

set -e

PACKAGE_NAME="lz-scan"

echo "=== 安装亮仔扫描图标 ==="

# 检查权限
if [ "$EUID" -ne 0 ]; then
    echo "请使用sudo运行此脚本"
    exit 1
fi

# 安装hicolor图标
echo "安装hicolor图标..."
if [ -d "hicolor" ]; then
    cp -r hicolor/* /usr/share/icons/hicolor/
    echo "✓ hicolor图标已安装"
fi

# 安装pixmaps图标
echo "安装pixmaps图标..."
if [ -f "pixmaps/${PACKAGE_NAME}.png" ]; then
    cp "pixmaps/${PACKAGE_NAME}.png" /usr/share/pixmaps/
    echo "✓ pixmaps图标已安装"
fi

# 更新图标缓存
echo "更新图标缓存..."
if command -v gtk-update-icon-cache >/dev/null 2>&1; then
    gtk-update-icon-cache -q /usr/share/icons/hicolor/ || true
    echo "✓ 图标缓存已更新"
fi

echo "图标安装完成！"
