Name:           lz-scan
Version:        1.6.6
Release:        1%{?dist}
Summary:        亮仔扫描 - 现代化文档扫描应用程序
Summary(en):    LZ Scan - Modern Document Scanning Application

License:        GPLv3+
URL:            https://github.com/tonglingcn/lz-scan
Source0:        %{name}-%{version}.tar.gz

BuildRequires:  cmake >= 3.10
BuildRequires:  gcc-c++
BuildRequires:  make
BuildRequires:  qt5-qtbase-devel >= 5.12.0
BuildRequires:  qt5-qttools-devel
BuildRequires:  sane-backends-devel >= 1.0.0
BuildRequires:  pkgconfig
BuildRequires:  desktop-file-utils

Requires:       qt5-qtbase >= 5.12.0
Requires:       sane-backends >= 1.0.0
Recommends:     sane-backends-drivers-scanners
Suggests:       xsane

%description
亮仔扫描是一个功能丰富的文档扫描应用程序，基于Qt5和SANE开发。

主要功能包括：
* 支持所有SANE兼容的扫描仪设备
* 多种扫描模式：彩色、灰度、黑白
* 强大的图像处理功能：旋转、裁剪、亮度调整
* 文档增强：角度调整、文档增强、背景漂白
* 实时预览：亮度/对比度、色度/饱和度调整
* 多页文档管理和批量扫描
* 循环延时扫描功能
* 撤销功能（最多10步）
* 多种输出格式：PDF, PNG, JPEG, BMP, TIFF
* 智能合并和拆分功能

该程序提供现代化的用户界面和良好的用户体验。

%description -l en
LZ Scan is a feature-rich document scanning application based on Qt5 and SANE.

Main features include:
* Support for all SANE-compatible scanner devices
* Multiple scan modes: Color, Grayscale, Black & White
* Powerful image processing: Rotation, Cropping, Brightness adjustment
* Document enhancement: Angle adjustment, Document enhancement, Background bleaching
* Real-time preview: Brightness/Contrast, Hue/Saturation adjustment
* Multi-page document management and batch scanning
* Loop delay scanning function
* Undo function (up to 10 steps)
* Multiple output formats: PDF, PNG, JPEG, BMP, TIFF
* Smart merge and split functions

The program provides a modern user interface and good user experience.

%prep
%autosetup

%build
%cmake
%cmake_build

%install
%cmake_install

# 安装桌面文件
desktop-file-install \
    --dir=%{buildroot}%{_datadir}/applications \
    debian/%{name}.desktop

%files
%license debian/copyright
%doc README.md CHANGELOG.md
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
%{_mandir}/man1/%{name}.1*

%changelog
* Sat Oct 19 2025 克亮 <315707022@qq.com> - 1.6.6-1
- 修复部分扫描仪扫描图像为全黑的问题
- 优化扫描数据读取逻辑，增大缓冲区到 32KB
- 修复 ADF 多页扫描黑屏问题
- 实现行缓冲机制，性能提升 8.8 倍
- 增加详细的扫描过程调试日志
- 统一平板和 ADF 扫描逻辑
- 增强对多品牌扫描仪的兼容性

* Sun Oct 12 2025 克亮 <315707022@qq.com> - 1.6.5-1
- 智能拆分合并功能优化
- 修复自动拆分检测逻辑，从基于A4尺寸改为基于内容区域检测
- 重新设计工具栏合并图片功能，去除模板选择，简化操作
- 重新设计 layout.svg 和 layout-columns.svg 图标，统一中国风设计风格
- 修改多选快捷键提示从 Ctrl 改为 Shift
- 添加智能拆分合并自动化功能
- 支持不同DPI扫描的A4纸张自动识别
- 完善文档和使用说明

* Mon Oct 07 2025 克亮 <315707022@qq.com> - 1.6.1-1
- 网络设备支持完善
- 修复 TCP 网络设备无法搜索的问题
- 优化设备搜索策略，参考 deepin-scanner
- 保留网络设备的完整连接信息
- 完善状态栏反馈和进度显示
- 添加重复设备自动去重功能
- 修复切换搜索模式需要搜索两次的问题

* Thu Oct 02 2025 克亮 <315707022@qq.com> - 1.5.0-1
- 初始 RPM 发布
- 完整功能实现
- 支持多种扫描模式和图像处理功能
