#!/bin/bash

# 准备上传到 GitHub 的脚本
# 此脚本将清理不必要的文件，只保留重要内容

echo "准备亮仔扫描项目以上传到 GitHub..."

# 确保我们在正确的目录
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd "$SCRIPT_DIR"

# 创建一个临时目录用于存放要上传的文件
TEMP_DIR="github-upload-temp"
mkdir -p "$TEMP_DIR"

# 复制重要的源代码文件
echo "复制源代码文件..."
mkdir -p "$TEMP_DIR/src"
cp -r src/* "$TEMP_DIR/src/"

# 复制 CMake 文件
echo "复制 CMake 文件..."
cp CMakeLists.txt "$TEMP_DIR/"
mkdir -p "$TEMP_DIR/cmake"
cp -r cmake/* "$TEMP_DIR/cmake/" 2>/dev/null || true

# 复制资源文件
echo "复制资源文件..."
mkdir -p "$TEMP_DIR/resources"
cp -r resources/* "$TEMP_DIR/resources/" 2>/dev/null || true

# 复制图标
echo "复制图标文件..."
mkdir -p "$TEMP_DIR/icons"
cp -r icons/* "$TEMP_DIR/icons/" 2>/dev/null || true
cp lz-scan.svg "$TEMP_DIR/"

# 复制文档
echo "复制文档文件..."
cp README.md "$TEMP_DIR/"
cp LICENSE "$TEMP_DIR/"
cp arch.md "$TEMP_DIR/"
cp PROJECT_SUMMARY.md "$TEMP_DIR/"

# 复制 .gitignore
cp .gitignore "$TEMP_DIR/"

# 复制有用的脚本
echo "复制有用的脚本..."
cp generate_icons_improved.sh "$TEMP_DIR/" 2>/dev/null || true

echo "清理临时文件和编译产物..."
find "$TEMP_DIR" -name "*.o" -delete
find "$TEMP_DIR" -name "*.obj" -delete
find "$TEMP_DIR" -name "moc_*" -delete
find "$TEMP_DIR" -name "ui_*" -delete
find "$TEMP_DIR" -name "qrc_*" -delete
find "$TEMP_DIR" -name "*.user" -delete
find "$TEMP_DIR" -name ".DS_Store" -delete
find "$TEMP_DIR" -name "Thumbs.db" -delete

echo "完成！准备好的文件在 $TEMP_DIR 目录中"
echo "您可以使用以下命令初始化 Git 仓库并上传到 GitHub："
echo ""
echo "cd $TEMP_DIR"
echo "git init"
echo "git add ."
echo "git commit -m \"Initial commit\""
echo "git branch -M main"
echo "git remote add origin https://github.com/tonglingcn/lz-scan.git"
echo "git push -u origin main"
echo ""
echo "注意：请将 'yourusername' 替换为您的 GitHub 用户名"