#ifndef CROPPABLEIMAGEWIDGET_H
#define CROPPABLEIMAGEWIDGET_H

#include <QLabel>
#include <QMouseEvent>
#include <QPaintEvent>
#include <QRubberBand>
#include <QRect>
#include <QPoint>

class CroppableImageWidget : public QLabel
{
    Q_OBJECT

public:
    explicit CroppableImageWidget(QWidget *parent = nullptr);
    ~CroppableImageWidget();

    void setCroppingEnabled(bool enabled);
    bool isCroppingEnabled() const;
    
    void setImage(const QImage &image);
    QImage getImage() const;
    
    QRect getCropRect() const;
    void clearCropRect();

signals:
    void cropRectChanged(const QRect &rect);
    void cropCompleted(const QRect &rect);
    void cropCancelled();

protected:
    void mousePressEvent(QMouseEvent *event) override;
    void mouseMoveEvent(QMouseEvent *event) override;
    void mouseReleaseEvent(QMouseEvent *event) override;
    void paintEvent(QPaintEvent *event) override;
    void keyPressEvent(QKeyEvent *event) override;

private:
    bool m_croppingEnabled;
    bool m_dragging;
    QPoint m_startPoint;
    QPoint m_endPoint;
    QRect m_cropRect;
    QRubberBand *m_rubberBand;
    QImage m_originalImage;
    
    // 辅助函数
    QRect normalizeRect(const QPoint &p1, const QPoint &p2) const;
    QRect mapToImageCoordinates(const QRect &widgetRect) const;
    QRect mapToWidgetCoordinates(const QRect &imageRect) const;
};

#endif // CROPPABLEIMAGEWIDGET_H