#include "mainwindow.h"
#include "platform_detection.h"

#include <QApplication>
#include <QTranslator>
#include <QLibraryInfo>
#include <QLocale>
#include <QSettings>
#include <QDir>
#include <QDebug>
#include <QTimer>
#include <QMessageBox>

#include <chrono>
#include <iostream>

// 声明平台信息打印函数
extern void scanx_print_platform_info();

int main(int argc, char *argv[])
{
    auto start = std::chrono::high_resolution_clock::now();
    // 设置应用程序信息
    QCoreApplication::setOrganizationName("亮仔扫描");
    QCoreApplication::setOrganizationDomain("lz-scan");
    QCoreApplication::setApplicationName("亮仔扫描");
    QCoreApplication::setApplicationVersion("1.6.6");
    
    // 创建应用程序实例
    QApplication app(argc, argv);
    
    // 打印平台信息
    scanx_print_platform_info();
    
    // 设置应用程序样式
    app.setStyle("Fusion");
    
    
    // 创建主窗口
    MainWindow mainWindow;
    mainWindow.m_startTime = start;
    mainWindow.setWindowTitle("亮仔扫描");
    mainWindow.resize(1024, 768); // 设置初始大小
    mainWindow.move(100, 100);   // 设置初始位置
    mainWindow.show();
    mainWindow.raise();
    QCoreApplication::processEvents(); // 处理事件队列
    QThread::msleep(1); // 短暂延迟
    mainWindow.activateWindow();
    
    // 如果窗口仍未激活，尝试更强制的方法
    if (!mainWindow.isActiveWindow()) {
        mainWindow.setWindowState(Qt::WindowNoState);
        mainWindow.setWindowState(Qt::WindowActive);
    }
    
    qDebug() << "MainWindow created at position:" << mainWindow.pos() 
             << "with size:" << mainWindow.size()
             << "isVisible:" << mainWindow.isVisible()
             << "isActiveWindow:" << mainWindow.isActiveWindow();
    
    // 处理命令行参数
    QStringList args = app.arguments();
    if (args.size() > 1) {
        QString filePath = args.at(1);
        QFileInfo fileInfo(filePath);
        if (fileInfo.exists() && fileInfo.isFile()) {
            // TODO: 打开文件
            qDebug() << "打开文件: " << filePath;
        }
    }
    
    // 运行应用程序
    return app.exec();
}