#include "platform_detection.h"
#include <QSysInfo>
#include <QDebug>

// 平台信息函数实现

const char* scanx_get_arch_name() {
    return SCANX_ARCH_NAME;
}

const char* scanx_get_os_name() {
    return SCANX_OS_NAME;
}

const char* scanx_get_compiler_name() {
    return SCANX_COMPILER_NAME;
}

int scanx_get_compiler_version() {
    return SCANX_COMPILER_VERSION;
}

bool scanx_is_little_endian() {
#ifdef SCANX_LITTLE_ENDIAN
    return true;
#else
    return false;
#endif
}

// 平台信息打印函数
void scanx_print_platform_info() {
    qDebug() << "=== 系统环境信息 ===";
    qDebug() << "架构:" << scanx_get_arch_name();
    qDebug() << "操作系统:" << scanx_get_os_name();
    qDebug() << "编译器:" << scanx_get_compiler_name();
    qDebug() << "编译器版本:" << scanx_get_compiler_version();
    qDebug() << "字节序:" << (scanx_is_little_endian() ? "小端" : "大端");
    qDebug() << "Qt版本:" << QT_VERSION_STR;
    qDebug() << "系统信息:" << QSysInfo::prettyProductName();
    qDebug() << "内核版本:" << QSysInfo::kernelVersion();
    qDebug() << "CPU架构:" << QSysInfo::currentCpuArchitecture();
    qDebug() << "构建CPU架构:" << QSysInfo::buildCpuArchitecture();
    
#ifdef SCANX_CACHE_LINE_SIZE
    qDebug() << "缓存行大小:" << SCANX_CACHE_LINE_SIZE << "字节";
#endif

#ifdef SCANX_SIMD_AVAILABLE
    qDebug() << "SIMD支持: x86 SSE/AVX";
#elif defined(SCANX_NEON_AVAILABLE)
    qDebug() << "SIMD支持: ARM NEON";
#elif defined(SCANX_LSX_AVAILABLE)
    qDebug() << "SIMD支持: LoongArch LSX";
#else
    qDebug() << "SIMD支持: 无";
#endif

    qDebug() << "=============================";
}