# OBS 快速开始指南

## 🚀 5 分钟上手 OBS

### 前提条件

- ✅ 本地编译成功
- ✅ 已运行 `./package_for_obs.sh`
- ✅ 已运行 `./check_obs_package.sh` 并通过

---

## 步骤 1: 注册 OBS 账号（2分钟）

1. 访问 https://build.opensuse.org/
2. 点击 "Sign Up" 注册
3. 验证邮箱并登录

---

## 步骤 2: 创建项目和包（1分钟）

### Web 界面方式

1. 登录后点击 "Your Home Project"
2. 点击 "Create Package"
3. 填写：
   - Name: `lz-scan`
   - Title: `亮仔扫描`
4. 点击 "Save Changes"

---

## 步骤 3: 上传文件（1分钟）

1. 进入包页面
2. 点击 "Add file"
3. 上传两个文件：
   - `obs_package/lz-scan-1.6.6.tar.gz`
   - `obs_package/lz-scan.spec`
4. 等待上传完成

---

## 步骤 4: 等待构建（5-30分钟）

1. 点击 "Build Results" 标签
2. 查看构建状态
3. 等待变成绿色 ✅

---

## 步骤 5: 测试安装（1分钟）

### openSUSE Tumbleweed

```bash
sudo zypper addrepo https://download.opensuse.org/repositories/home:/你的用户名/openSUSE_Tumbleweed/home:你的用户名.repo
sudo zypper refresh
sudo zypper install lz-scan
```

---

## 🎉 完成！

你的软件包现在可以在 OBS 上自动构建了！

---

## 下一步

### 添加更多发行版

1. 进入项目页面
2. 点击 "Repositories" 标签
3. 点击 "Add from a Distribution"
4. 选择：
   - ✅ Fedora 40
   - ✅ Debian 12
   - ✅ Ubuntu 24.04
   - ✅ Ubuntu 22.04
5. 点击 "Add selected repositories"

OBS 会自动为所有选择的发行版构建！

---

## 常见问题

### Q: 构建失败怎么办？

A: 
1. 点击失败的发行版
2. 查看构建日志
3. 搜索 "error:"
4. 参考 `OBS编译问题分析.md`

### Q: 构建需要多长时间？

A: 通常 5-30 分钟，取决于：
- 构建队列长度
- 软件包大小
- 依赖数量

### Q: 如何让用户安装？

A: 提供安装命令，例如：

```bash
# openSUSE
sudo zypper addrepo [仓库地址]
sudo zypper install lz-scan

# Fedora
sudo dnf config-manager --add-repo [仓库地址]
sudo dnf install lz-scan

# Debian/Ubuntu
wget -qO - [密钥地址] | sudo apt-key add -
echo 'deb [仓库地址] /' | sudo tee /etc/apt/sources.list.d/lz-scan.list
sudo apt-get update
sudo apt-get install lz-scan
```

---

## 更多帮助

- 📖 详细指南: `OBS多发行版编译指南.md`
- 🔧 问题分析: `OBS编译问题分析.md`
- 📤 上传指南: `OBS上传指南.md`

---

**开始时间**: 现在  
**预计完成**: 5-10 分钟  
**难度**: ⭐⭐☆☆☆
