#!/bin/bash

# 亮仔扫描 DEB 包构建脚本（标准Debian方式）
# 版本: 1.6.6

set -e

# 颜色定义
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'

echo -e "${BLUE}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo -e "${BLUE}  亮仔扫描 DEB 包构建工具（标准方式）${NC}"
echo -e "${BLUE}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo ""

# 检查必要的工具
echo -e "${YELLOW}检查构建工具...${NC}"
MISSING_TOOLS=""

for tool in dpkg-buildpackage cmake; do
    if ! command -v $tool >/dev/null 2>&1; then
        MISSING_TOOLS="$MISSING_TOOLS $tool"
    fi
done

# 检查debhelper包是否安装
if ! dpkg -l | grep -q "^ii  debhelper"; then
    MISSING_TOOLS="$MISSING_TOOLS debhelper"
fi

if [ -n "$MISSING_TOOLS" ]; then
    echo -e "${RED}错误: 缺少必要的构建工具:${MISSING_TOOLS}${NC}"
    echo -e "${YELLOW}请安装:${NC}"
    echo "  sudo apt-get install build-essential debhelper cmake"
    exit 1
fi

echo -e "${GREEN}✓ 所有构建工具已就绪${NC}"

# 检查debian目录
if [ ! -d "debian" ]; then
    echo -e "${RED}错误: 找不到debian目录${NC}"
    echo -e "${YELLOW}请确保在项目根目录运行此脚本${NC}"
    exit 1
fi

echo -e "${GREEN}✓ 找到debian目录${NC}"

# 清理旧的构建文件
echo -e "${YELLOW}清理旧的构建文件...${NC}"
rm -rf build
rm -f ../*.deb ../*.changes ../*.buildinfo ../*.dsc ../*.tar.* 2>/dev/null || true

# 构建包
echo ""
echo -e "${BLUE}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo -e "${BLUE}  开始构建DEB包...${NC}"
echo -e "${BLUE}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo ""

# 使用dpkg-buildpackage构建
dpkg-buildpackage -us -uc -b

# 检查构建结果
echo ""
echo -e "${BLUE}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo -e "${BLUE}  构建完成！${NC}"
echo -e "${BLUE}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
echo ""

# 查找生成的deb包
DEB_FILE=$(ls -t ../*.deb 2>/dev/null | head -1)

if [ -n "$DEB_FILE" ]; then
    echo -e "${GREEN}✓ DEB包已生成: $DEB_FILE${NC}"
    
    # 显示包信息
    echo ""
    echo -e "${YELLOW}包信息:${NC}"
    dpkg-deb --info "$DEB_FILE"
    
    # 显示文件大小
    PACKAGE_SIZE=$(stat -c%s "$DEB_FILE")
    PACKAGE_SIZE_KB=$((PACKAGE_SIZE / 1024))
    PACKAGE_SIZE_MB=$((PACKAGE_SIZE_KB / 1024))
    
    echo ""
    echo -e "${GREEN}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
    echo -e "${GREEN}  构建成功！${NC}"
    echo -e "${GREEN}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
    echo -e "${GREEN}DEB包: $DEB_FILE${NC}"
    echo -e "${GREEN}大小: ${PACKAGE_SIZE_MB} MB (${PACKAGE_SIZE_KB} KB)${NC}"
    echo ""
    echo -e "${YELLOW}📦 安装命令:${NC}"
    echo "  sudo dpkg -i $DEB_FILE"
    echo "  sudo apt-get install -f  # 修复依赖（如需要）"
    echo ""
    echo -e "${YELLOW}🗑️  卸载命令:${NC}"
    echo "  sudo apt-get remove lz-scan"
    echo ""
    echo -e "${YELLOW}🔍 查看包内容:${NC}"
    echo "  dpkg-deb --contents $DEB_FILE"
    echo ""
    
    # 运行lintian检查（如果可用）
    if command -v lintian >/dev/null 2>&1; then
        echo -e "${YELLOW}运行包质量检查...${NC}"
        lintian "$DEB_FILE" || true
        echo ""
    fi
else
    echo -e "${RED}✗ 未找到生成的DEB包${NC}"
    exit 1
fi
