#!/bin/bash

# 检查版本号是否已更新为 1.6.6

echo "=========================================="
echo "检查 lz-scan v1.6.6 版本号"
echo "=========================================="
echo ""

VERSION="1.6.6"
ERRORS=0

# 检查 CMakeLists.txt
echo "1. 检查 CMakeLists.txt"
if grep -q "VERSION 1.6.6" CMakeLists.txt; then
    echo "   ✅ CMakeLists.txt 版本正确"
else
    echo "   ❌ CMakeLists.txt 版本错误"
    ERRORS=$((ERRORS + 1))
fi

# 检查 README.md
echo "2. 检查 README.md"
if grep -q "version-1.6.6" README.md; then
    echo "   ✅ README.md 版本正确"
else
    echo "   ❌ README.md 版本错误"
    ERRORS=$((ERRORS + 1))
fi

# 检查 CHANGELOG.md
echo "3. 检查 CHANGELOG.md"
if grep -q "\[1.6.6\]" CHANGELOG.md; then
    echo "   ✅ CHANGELOG.md 包含 1.6.6 条目"
else
    echo "   ❌ CHANGELOG.md 缺少 1.6.6 条目"
    ERRORS=$((ERRORS + 1))
fi

# 检查 debian/changelog
echo "4. 检查 debian/changelog"
if grep -q "lz-scan (1.6.6-1)" debian/changelog; then
    echo "   ✅ debian/changelog 版本正确"
else
    echo "   ❌ debian/changelog 版本错误"
    ERRORS=$((ERRORS + 1))
fi

# 检查 lz-scan.spec
echo "5. 检查 lz-scan.spec"
if grep -q "Version:        1.6.6" lz-scan.spec; then
    echo "   ✅ lz-scan.spec 版本正确"
else
    echo "   ❌ lz-scan.spec 版本错误"
    ERRORS=$((ERRORS + 1))
fi

echo ""
echo "=========================================="

if [ $ERRORS -eq 0 ]; then
    echo "✅ 所有版本号检查通过！"
    echo ""
    echo "版本更新内容："
    echo "  - 修复部分扫描仪扫描图像为全黑的问题"
    echo "  - 优化扫描数据读取逻辑"
    echo "  - 性能提升 8.8 倍"
    echo ""
    echo "下一步操作："
    echo "  1. 重新编译: cmake --build build -j\$(nproc)"
    echo "  2. 测试功能: ./test_scan.sh"
    echo "  3. 提交代码: git add . && git commit -m 'release: v1.6.6'"
    echo "  4. 创建标签: git tag v1.6.6"
    echo "  5. 推送代码: git push && git push --tags"
else
    echo "❌ 发现 $ERRORS 个错误，请检查并修复"
fi

echo "=========================================="
