# 空白页图标说明

## 图标文件

为"自动删除空白页"功能设计了多个版本的图标：

### 1. blank-page.svg (64x64)
- **用途**：高分辨率展示
- **风格**：详细版，带渐变和阴影
- **特点**：
  - 空白页面带折角
  - 淡淡的线条表示空白
  - 红色圆圈带白色 X 表示删除
  - 适合大图标展示

### 2. blank-page-simple.svg (48x48)
- **用途**：中等尺寸按钮
- **风格**：简洁版
- **特点**：
  - 清晰的轮廓
  - 简化的细节
  - 红色删除标记
  - 适合对话框按钮

### 3. blank-page-modern.svg (24x24) ⭐ 推荐
- **用途**：工具栏按钮
- **风格**：现代扁平风格
- **特点**：
  - 扁平设计
  - 清晰可辨
  - 小尺寸下效果好
  - **推荐用于主程序**

### 4. blank-page-color.svg (32x32)
- **用途**：彩色版本
- **风格**：带渐变和阴影
- **特点**：
  - 彩色渐变
  - 阴影效果
  - 更加醒目
  - 适合需要突出显示的场景

## 设计理念

### 视觉元素

1. **空白页面**
   - 白色或浅灰色背景
   - 带折角的文档形状
   - 淡淡的线条表示"空白"状态

2. **删除标记**
   - 红色圆圈（#dc3545）
   - 白色 X 标记
   - 位于右下角
   - 清晰表达"删除"动作

3. **颜色方案**
   - 页面：白色/浅灰 (#f8f9fa, #e9ecef)
   - 边框：深灰 (#495057, #6c757d)
   - 删除：红色 (#dc3545, #ff6b6b)
   - 线条：浅灰 (#dee2e6, #ced4da)

## 使用建议

### 在 Qt 资源文件中使用

1. **添加到 resources.qrc**
```xml
<RCC>
    <qresource prefix="/icons">
        <file>icons/blank-page-modern.svg</file>
    </qresource>
</RCC>
```

2. **在代码中使用**
```cpp
blankPageSettingsBtn->setIcon(QIcon(":/icons/blank-page-modern.svg"));
```

### 不同场景推荐

| 场景 | 推荐图标 | 尺寸 |
|------|----------|------|
| 工具栏按钮 | blank-page-modern.svg | 24x24 |
| 对话框按钮 | blank-page-simple.svg | 48x48 |
| 设置界面 | blank-page-color.svg | 32x32 |
| 文档展示 | blank-page.svg | 64x64 |

## 图标预览

### blank-page-modern.svg (推荐)
```
┌─────────┐
│ ┌─┐     │  ← 折角
│ │ │ ─── │  ← 空白线条
│ │ │ ─── │
│ │ │ ─── │
│ └─┘     │
│      (X)│  ← 红色删除标记
└─────────┘
```

### 特点说明
- ✅ 清晰易识别
- ✅ 小尺寸下效果好
- ✅ 符合现代扁平设计
- ✅ 颜色对比度高
- ✅ 语义明确（空白页 + 删除）

## 技术规格

### SVG 优点
- 矢量图形，任意缩放不失真
- 文件小，加载快
- 支持 CSS 样式修改
- Qt 原生支持

### 颜色代码
```css
/* 页面颜色 */
--page-bg: #f8f9fa;
--page-border: #6c757d;
--page-lines: #dee2e6;

/* 删除标记 */
--delete-bg: #dc3545;
--delete-icon: #ffffff;

/* 阴影 */
--shadow: rgba(0, 0, 0, 0.1);
```

## 自定义修改

如果需要修改图标：

1. **改变颜色**
   - 编辑 SVG 文件中的 `fill` 和 `stroke` 属性
   - 或使用 CSS 变量

2. **调整大小**
   - 修改 `viewBox` 属性
   - 保持宽高比

3. **简化/复杂化**
   - 添加/删除装饰元素
   - 调整线条粗细

## 版本历史

- **v1.0** (2025) - 初始设计
  - 创建 4 个不同版本
  - 适配不同使用场景
  - 统一设计语言

## 许可证

这些图标遵循项目的开源许可证。

## 反馈

如果对图标有任何建议或需要其他版本，请提出反馈。

---

**设计者**：AI Assistant (Kiro)  
**创建日期**：2025年  
**推荐使用**：blank-page-modern.svg
