# 布局图标说明

## 📐 图标设计

为"界面布局"功能设计了5个不同风格的图标，每个都有其独特的视觉语言。

## 🎨 图标列表

### 1. layout.svg - 基础布局图标

```
┌────────────────────┐
│    工具栏 (顶部)    │
├──────┬──────┬──────┤
│ 左侧 │ 中间 │ 右侧 │
│ 面板 │ 内容 │ 面板 │
└──────┴──────┴──────┘
```

**特点**：
- 清晰展示三栏布局
- 顶部工具栏明显
- 中间内容区用虚线表示
- 适合：标准布局展示

**使用场景**：通用布局图标

---

### 2. layout-grid.svg - 网格布局图标

```
┌────────────────────┐
│    工具栏 (顶部)    │
├──────┬──────┬──────┤
│  ●   │      │  ●   │
│      │      │      │
└──────┴──────┴──────┘
```

**特点**：
- 简洁的网格设计
- 用圆点标记关键区域
- 垂直分隔线清晰
- 适合：简约风格

**使用场景**：现代简约界面

---

### 3. layout-columns.svg - 列布局图标

```
┌────────────────────┐
│ 左列 ◄─► 右列      │
│      │      │      │
│      │      │      │
└──────┴──────┴──────┘
```

**特点**：
- 强调左右分栏
- 中间有明显分隔线
- 箭头表示可切换
- 适合：强调左右布局

**使用场景**：双栏布局切换

---

### 4. layout-dashboard.svg - 仪表板布局图标

```
┌────────────────────┐
│    工具栏 (顶部)    │
├──────────┬─────────┤
│          │  右上 ● │
│  左侧 ●  ├─────────┤
│          │  右下 ● │
└──────────┴─────────┘
```

**特点**：
- 现代仪表板风格
- 不对称布局
- 圆点装饰
- 适合：复杂布局

**使用场景**：多面板布局

---

### 5. layout-switch.svg - 布局切换图标 ⭐ (推荐)

```
┌────────────────────┐
│    工具栏 (顶部)    │
├──────┬──────────┬──┤
│ ►    │          │◄ │
│ 左侧 │   中间   │右│
└──────┴──────────┴──┘
```

**特点**：
- 清晰的三栏布局
- 左右箭头表示可切换
- 视觉平衡
- 适合：布局切换功能

**使用场景**：✅ 当前使用（推荐）

---

## 🎯 推荐使用

### 当前使用：layout-switch.svg

**选择理由**：
1. ✅ 清晰展示布局结构
2. ✅ 箭头暗示可切换
3. ✅ 视觉平衡，易识别
4. ✅ 符合功能语义

### 替代方案

| 场景 | 推荐图标 | 理由 |
|------|---------|------|
| 简约风格 | layout-grid.svg | 更简洁 |
| 强调分栏 | layout-columns.svg | 突出左右布局 |
| 复杂布局 | layout-dashboard.svg | 展示多面板 |
| 通用场景 | layout.svg | 标准布局图标 |

## 🎨 设计规范

### 尺寸
- 画布：24x24 px
- 图标内容：20x20 px（留2px边距）

### 颜色
- 使用 `currentColor`
- 自动适应主题颜色
- 不透明度：0.2 - 0.7

### 风格
- 线条宽度：1.5px
- 圆角：1-2px
- 简洁现代

## 📝 使用方法

### 在代码中使用

```cpp
// 使用推荐图标
QAction *layoutAction = new QAction(
    QIcon(":/icons/layout-switch.svg"), 
    tr("界面布局"), 
    this
);

// 或使用其他图标
QIcon(":/icons/layout-grid.svg")
QIcon(":/icons/layout-columns.svg")
QIcon(":/icons/layout-dashboard.svg")
QIcon(":/icons/layout.svg")
```

### 在 resources.qrc 中

```xml
<file>icons/layout.svg</file>
<file>icons/layout-grid.svg</file>
<file>icons/layout-columns.svg</file>
<file>icons/layout-dashboard.svg</file>
<file>icons/layout-switch.svg</file>
```

## 🔄 切换图标

如果想更换图标，只需修改代码中的图标路径：

```cpp
// 从
QIcon(":/icons/layout-switch.svg")

// 改为
QIcon(":/icons/layout-grid.svg")
```

## 🎨 自定义图标

如果需要自定义图标：

1. 复制现有 SVG 文件
2. 修改路径和形状
3. 保持 24x24 尺寸
4. 使用 `currentColor`
5. 添加到 resources.qrc
6. 重新编译

## 📊 图标对比

| 图标 | 复杂度 | 识别度 | 美观度 | 推荐度 |
|------|--------|--------|--------|--------|
| layout.svg | ⭐⭐⭐ | ⭐⭐⭐⭐ | ⭐⭐⭐ | ⭐⭐⭐ |
| layout-grid.svg | ⭐⭐ | ⭐⭐⭐⭐ | ⭐⭐⭐⭐ | ⭐⭐⭐⭐ |
| layout-columns.svg | ⭐⭐⭐ | ⭐⭐⭐ | ⭐⭐⭐ | ⭐⭐⭐ |
| layout-dashboard.svg | ⭐⭐⭐⭐ | ⭐⭐⭐ | ⭐⭐⭐⭐ | ⭐⭐⭐ |
| layout-switch.svg | ⭐⭐⭐ | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ |

## ✅ 总结

- ✅ 提供了5种不同风格的布局图标
- ✅ 当前使用 `layout-switch.svg`（推荐）
- ✅ 所有图标都支持主题颜色
- ✅ 可以根据需要轻松切换

---

**设计版本**：v1.0  
**设计日期**：2025年10月11日  
**当前使用**：layout-switch.svg
