# 亮仔扫描 图标文件

本目录包含亮仔扫描应用程序的各种规格图标文件。

## 目录结构

- `standard/` - 标准PNG图标（各种尺寸）
- `hicolor/` - freedesktop.org hicolor主题图标
- `pixmaps/` - 系统pixmaps图标
- `applications/` - 应用程序图标
- `*.ico` - Windows图标文件
- `preview.html` - 图标预览页面

## 可用尺寸

- 16x16 像素
- 22x22 像素
- 24x24 像素
- 32x32 像素
- 48x48 像素
- 64x64 像素
- 96x96 像素
- 128x128 像素
- 256x256 像素
- 512x512 像素

## 预览图标

在浏览器中打开 `preview.html` 文件可以预览所有生成的图标。

## 安装方法

### 自动安装
```bash
sudo ./install_icons.sh
```

### 手动安装
```bash
# 复制hicolor图标
sudo cp -r hicolor/* /usr/share/icons/hicolor/

# 复制pixmaps图标
sudo cp pixmaps/lz-scan.png /usr/share/pixmaps/

# 更新图标缓存
sudo gtk-update-icon-cache /usr/share/icons/hicolor/
```

## 卸载方法
```bash
sudo ./uninstall_icons.sh
```

## 文件用途

- **16x16**: 小图标、状态栏
- **22x22**: 面板图标
- **24x24**: 小工具栏
- **32x32**: 中等图标
- **48x48**: 标准桌面图标
- **64x64**: 大图标
- **96x96**: 高DPI小图标
- **128x128**: 高DPI中等图标
- **256x256**: 高DPI大图标
- **512x512**: 超高清图标

## 技术信息

- 源文件: lz-scan.svg
- 生成工具: rsvg-convert
- 生成时间: 2025年 09月 19日 星期五 21:04:21 CST

## 故障排除

如果图标显示为黑色或不正确：

1. 检查SVG文件是否包含复杂的效果或中文字体
2. 尝试安装Inkscape获得更好的渲染质量: `sudo apt install inkscape`
3. 使用简化版SVG文件: `lz-scan-simple.svg`

