#!/bin/bash

# 亮仔扫描 图标卸载脚本

set -e

PACKAGE_NAME="lz-scan"

echo "=== 卸载亮仔扫描图标 ==="

# 检查权限
if [ "$EUID" -ne 0 ]; then
    echo "请使用sudo运行此脚本"
    exit 1
fi

# 删除hicolor图标
echo "删除hicolor图标..."
for size in 16 22 24 32 48 64 96 128 256 512; do
    rm -f "/usr/share/icons/hicolor/${size}x${size}/apps/${PACKAGE_NAME}.png"
done

# 删除pixmaps图标
echo "删除pixmaps图标..."
rm -f "/usr/share/pixmaps/${PACKAGE_NAME}.png"

# 更新图标缓存
echo "更新图标缓存..."
if command -v gtk-update-icon-cache >/dev/null 2>&1; then
    gtk-update-icon-cache -q /usr/share/icons/hicolor/ || true
    echo "✓ 图标缓存已更新"
fi

echo "图标卸载完成！"
