#ifndef DOCUMENTMANAGER_H
#define DOCUMENTMANAGER_H

#include <QObject>
#include <QImage>
#include <QList>
#include <QString>
#include <QFileInfo>
#include <QDateTime>

class DocumentManager : public QObject
{
    Q_OBJECT

public:
    explicit DocumentManager(QObject *parent = nullptr);
    ~DocumentManager();

    // 文档操作
    void newDocument();
    bool loadDocument(const QString &filePath);
    bool saveDocument(const QString &filePath);
    bool exportDocument(const QString &filePath, const QString &format);
    
    // 页面操作
    void addImage(const QImage &image);
    void insertImage(int index, const QImage &image);
    void removePage(int index);
    void movePageUp(int index);
    void movePageDown(int index);
    void setCurrentPage(int index);
    
    // 获取页面
    QImage getPage(int index) const;
    QImage getCurrentImage() const;
    int getCurrentPageIndex() const;
    int getPageCount() const;
    
    // 文档状态
    bool hasUnsavedChanges() const;
    QString getCurrentFilePath() const;
    QString getDocumentTitle() const;
    
    // 保存方法
    bool saveAsImage(const QString &filePath);

signals:
    void documentChanged();
    void pageAdded(int index);
    void pageRemoved(int index);
    void pageMoved(int oldIndex, int newIndex);
    void currentPageChanged(int index);
    void documentSaved(const QString &filePath);
    void documentLoaded(const QString &filePath);
    void documentError(const QString &errorMessage);

private:
    // 辅助函数
    bool saveAsPDF(const QString &filePath);
    bool saveAsMultiPageTIFF(const QString &filePath);
    
    // 文档数据
    QList<QImage> m_pages;
    int m_currentPageIndex;
    QString m_filePath;
    QString m_documentTitle;
    bool m_hasUnsavedChanges;
    
    // 文件格式支持
    QStringList m_supportedImageFormats;
};

#endif // DOCUMENTMANAGER_H